/*
 * Decompiled with CFR 0.152.
 */
package glenn.moddingutils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class UpdateChecker
implements Runnable {
    private final Gson gson = new Gson();
    private final LinkedList<VersionMessage> relevantMessages = new LinkedList();
    private File messageCounterFile;
    private ArrayList<MessageCounter> counters;
    private boolean requestValid = false;
    private final String urlString;
    private final String fullModName;
    private final String modID;
    private final String modVersion;
    private final String minecraftVersion;

    public UpdateChecker(String url, String fullModName, String modID, String modVersion, String minecraftVersion) {
        this.urlString = url;
        this.fullModName = fullModName;
        this.modID = modID;
        this.modVersion = modVersion;
        this.minecraftVersion = minecraftVersion;
        Thread async = new Thread(this);
        async.start();
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (this.requestValid && event.world.field_72995_K && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            LinkedList<IChatComponent> messageQueue = new LinkedList<IChatComponent>();
            for (VersionMessage message : this.relevantMessages) {
                this.printMessage(message, messageQueue);
            }
            for (IChatComponent component : messageQueue) {
                player.func_145747_a(component);
            }
            messageQueue.clear();
            try {
                this.writeMessageCounterFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private File createMetaDirectory() throws FileNotFoundException {
        File readMeFile;
        File metaDirectory = new File(Minecraft.func_71410_x().field_71412_D.getPath() + "/config/" + this.fullModName);
        if (!metaDirectory.exists()) {
            metaDirectory.mkdirs();
        }
        if ((readMeFile = new File(metaDirectory.getPath() + "/readMe.txt")).exists()) {
            readMeFile.delete();
        }
        PrintWriter writer = new PrintWriter(readMeFile);
        writer.print(String.format("This is a folder used by %1$s, a Minecraft mod you have installed.%nThis folder, or the contents of this folder, should not be removed or altered as long as %1$s is installed.%nThe folder is only used as a small local data store to save data between sessions.%nTo disable the use of this folder, disable the update checker in the configurations of %1$s", this.fullModName));
        writer.close();
        return metaDirectory;
    }

    private ArrayList<MessageCounter> readMessageCounterFile() throws FileNotFoundException, IOException {
        ArrayList result = null;
        if (this.messageCounterFile.exists()) {
            FileReader reader = new FileReader(this.messageCounterFile);
            result = (ArrayList)this.gson.fromJson((Reader)reader, new TypeToken<ArrayList<MessageCounter>>(){}.getType());
            reader.close();
            if (result == null) {
                result = new ArrayList();
            }
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    private void writeMessageCounterFile() throws IOException {
        if (this.messageCounterFile.exists()) {
            this.messageCounterFile.createNewFile();
        }
        FileWriter writer = new FileWriter(this.messageCounterFile);
        this.gson.toJson(this.counters, (Appendable)writer);
        writer.close();
    }

    private ArrayList<VersionMessage> getVersionMessages(URL url) throws IOException {
        HttpsURLConnection httpsConnection = (HttpsURLConnection)url.openConnection();
        httpsConnection.setReadTimeout(10000);
        httpsConnection.setRequestMethod("POST");
        httpsConnection.setRequestProperty("User-Agent", "Minecraft");
        httpsConnection.setDoOutput(true);
        DataOutputStream out = new DataOutputStream(httpsConnection.getOutputStream());
        out.writeBytes("modID=" + this.modID + "&minecraftVersion=" + this.minecraftVersion + "&modVersion=" + this.modVersion);
        out.flush();
        out.close();
        InputStreamReader in = new InputStreamReader(httpsConnection.getInputStream());
        ArrayList versionMessages = (ArrayList)this.gson.fromJson((Reader)in, new TypeToken<ArrayList<VersionMessage>>(){}.getType());
        in.close();
        if (versionMessages != null) {
            return versionMessages;
        }
        return new ArrayList<VersionMessage>();
    }

    private boolean isValid(VersionMessage message) {
        if (message != null) {
            if (message.id == -1) {
                return false;
            }
            if (message.timesToShow == 0) {
                return false;
            }
            return this.versionInRanges(this.minecraftVersion, message.minecraftVersions) && this.versionInRanges(this.modVersion, message.modVersions);
        }
        return false;
    }

    private void processVersionMessage(VersionMessage message) {
        if (this.isValid(message)) {
            MessageCounter counter = null;
            for (int i = 0; i < this.counters.size(); ++i) {
                MessageCounter c = this.counters.get(i);
                if (c == null || c.id != message.id) continue;
                counter = c;
                break;
            }
            if (counter == null) {
                counter = new MessageCounter(message.id, message.timesToShow);
                this.counters.add(counter);
            } else if (counter.timesToShow != message.timesToShow) {
                counter.timesToShow = message.timesToShow;
                counter.timesShown = 0;
            }
            this.relevantMessages.add(message);
        }
    }

    private void printMessage(VersionMessage message, LinkedList<IChatComponent> messageQueue) {
        MessageCounter counter = null;
        for (int i = 0; i < this.counters.size(); ++i) {
            String[] c = this.counters.get(i);
            if (c == null || c.id != message.id) continue;
            counter = c;
            break;
        }
        if (counter != null && counter.shouldShow()) {
            boolean anythingPrinted = false;
            if (message.displayName != null && message.displayName.length() > 0) {
                anythingPrinted = true;
                messageQueue.add(new ChatComponentText(message.displayName).func_150255_a(this.getImportanceStyle(message.importance).func_150227_a(Boolean.valueOf(true))));
            }
            if (message.description != null) {
                for (String desc : message.description) {
                    if (desc == null) continue;
                    anythingPrinted = true;
                    messageQueue.add(new ChatComponentText(desc).func_150255_a(this.getImportanceStyle(message.importance)));
                }
            }
            if (message.URL != null && message.URL.length() > 0) {
                anythingPrinted = true;
                ChatComponentText component = new ChatComponentText(message.URL);
                ChatStyle style = component.func_150256_b();
                style.func_150228_d(Boolean.valueOf(true));
                style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, message.URL));
                messageQueue.add((IChatComponent)component);
            }
            if (anythingPrinted) {
                messageQueue.add((IChatComponent)new ChatComponentText(""));
                ChatStyle style = new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW);
                ++counter.timesShown;
                if (!counter.shouldAlwaysShow()) {
                    int timesLeft = counter.timesToShow - counter.timesShown;
                    if (timesLeft == 0) {
                        messageQueue.add(new ChatComponentText("This message will not be shown again.").func_150255_a(style));
                    } else if (timesLeft == 1) {
                        messageQueue.add(new ChatComponentText("This message will be shown one more time.").func_150255_a(style));
                    } else if (timesLeft > 1) {
                        messageQueue.add(new ChatComponentText("This message will be shown " + timesLeft + " more times.").func_150255_a(style));
                    }
                }
                messageQueue.add(new ChatComponentText("This update checker can be disabled in the configurations.").func_150255_a(style));
            }
        }
    }

    private ChatStyle getImportanceStyle(int importance) {
        switch (importance) {
            case 0: {
                return new ChatStyle().func_150238_a(EnumChatFormatting.DARK_GREEN);
            }
            case 1: {
                return new ChatStyle().func_150238_a(EnumChatFormatting.BLUE);
            }
            case 2: {
                return new ChatStyle().func_150238_a(EnumChatFormatting.DARK_RED);
            }
        }
        return new ChatStyle();
    }

    private boolean versionInRanges(String version, String[] ranges) {
        if (ranges == null || ranges.length == 0) {
            return true;
        }
        boolean result = false;
        for (int i = 0; i < ranges.length; ++i) {
            result ^= this.versionInRange(version, ranges[i]);
        }
        return result;
    }

    private boolean versionInRange(String version, String range) {
        if (range == null || range.length() == 0) {
            return true;
        }
        int iVersion = this.versionStringToInt(version);
        if (range.startsWith("<=")) {
            return iVersion <= this.versionStringToInt(range.substring(2));
        }
        if (range.startsWith(">=")) {
            return iVersion >= this.versionStringToInt(range.substring(2));
        }
        if (range.startsWith("<")) {
            return iVersion < this.versionStringToInt(range.substring(1));
        }
        if (range.startsWith(">")) {
            return iVersion > this.versionStringToInt(range.substring(1));
        }
        String[] split = range.split("-");
        if (split.length == 2) {
            int iRange1 = this.versionStringToInt(split[0]);
            int iRange2 = this.versionStringToInt(split[1]);
            return iVersion <= iRange1 & iVersion >= iRange2 | iVersion >= iRange1 & iVersion <= iRange2;
        }
        return iVersion == this.versionStringToInt(range);
    }

    private int versionStringToInt(String version) {
        int versionScore = 0;
        int multiplier = 1000000000;
        String[] splitVersion = version.split("\\.");
        int i = 0;
        while (i < splitVersion.length) {
            versionScore += Integer.parseInt(splitVersion[i]) * multiplier;
            ++i;
            multiplier /= 1000;
        }
        return versionScore;
    }

    @Override
    public void run() {
        try {
            File metaDirectory = this.createMetaDirectory();
            this.messageCounterFile = new File(metaDirectory.getPath() + "/messageCounter.json");
            this.counters = this.readMessageCounterFile();
            ArrayList<VersionMessage> messages = this.getVersionMessages(new URL(this.urlString));
            for (VersionMessage message : messages) {
                this.processVersionMessage(message);
            }
            this.writeMessageCounterFile();
            this.requestValid = true;
        }
        catch (Exception e) {
            FMLLog.warning((String)(this.fullModName + " failed to check for update messages (" + e.toString() + ")"), (Object[])new Object[0]);
        }
    }

    private static class MessageCounter {
        public int id = -1;
        public int timesToShow = 1;
        public int timesShown = 0;

        public MessageCounter(int id, int timesToShow) {
            this.id = id;
            this.timesToShow = timesToShow;
        }

        public boolean shouldAlwaysShow() {
            return this.timesToShow == -1;
        }

        public boolean shouldShow() {
            return this.shouldAlwaysShow() || this.timesShown < this.timesToShow;
        }
    }

    private static class VersionMessage {
        public int id = -1;
        public int timesToShow = 1;
        public int importance = 1;
        public String[] minecraftVersions = new String[0];
        public String[] modVersions = new String[0];
        public String displayName = "";
        public String[] description = new String[0];
        public String modVersion = "";
        public String URL = "";

        private VersionMessage() {
        }
    }
}

