/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.foodqueue;

import net.minecraft.nbt.NBTTagCompound;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.foodqueue.FoodQueue;

public class FixedTimeQueue
extends FoodQueue {
    private static final long serialVersionUID = 4071948082682614961L;
    protected long tickLimit;

    public FixedTimeQueue(long tickLimit) {
        this.tickLimit = tickLimit;
    }

    public void prune(long absoluteTime, long relativeTime) {
        while (this.hasHeadExpired(absoluteTime, relativeTime)) {
            super.remove();
        }
    }

    public boolean hasHeadExpired(long absoluteTime, long relativeTime) {
        if (this.peekFirst() == null) {
            return false;
        }
        if (ModConfig.PROGRESS_TIME_WHILE_LOGGED_OFF) {
            return absoluteTime >= ((FoodEaten)this.peekFirst()).worldTimeEaten + this.tickLimit;
        }
        return relativeTime >= ((FoodEaten)this.peekFirst()).playerTimeEaten + this.tickLimit;
    }

    @Override
    public void readFromNBTData(NBTTagCompound data) {
        super.readFromNBTData(data);
    }

    @Override
    public void writeToNBTData(NBTTagCompound data) {
        super.writeToNBTData(data);
    }
}

