/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.foodtracker.FoodTracker;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroup;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupRegistry;
import squeek.spiceoflife.helpers.ColorHelper;
import squeek.spiceoflife.helpers.FoodHelper;
import squeek.spiceoflife.helpers.StringHelper;

@SideOnly(value=Side.CLIENT)
public class TooltipHandler {
    private static final DecimalFormat df = new DecimalFormat("##.##");

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (ModConfig.FOOD_MODIFIER_ENABLED && event.itemStack != null && FoodHelper.isValidFood(event.itemStack)) {
            boolean canDiminish;
            int totalFoodEaten = FoodHistory.get((EntityPlayer)event.entityPlayer).totalFoodsEatenAllTime;
            float foodModifier = 1.0f;
            ArrayList<String> toolTipStringsToAdd = new ArrayList<String>();
            FoodGroup foodGroup = FoodGroupRegistry.getFoodGroupForFood(event.itemStack);
            boolean bl = canDiminish = foodGroup == null || !foodGroup.blacklist;
            if (canDiminish && foodGroup != null && !foodGroup.hidden) {
                toolTipStringsToAdd.add(StatCollector.func_74838_a((String)"spiceoflife.tooltip.food.group") + EnumChatFormatting.ITALIC + foodGroup.getLocalizedName());
            }
            if (ModConfig.FOOD_EATEN_THRESHOLD > 0 && totalFoodEaten < ModConfig.FOOD_EATEN_THRESHOLD) {
                int timesUntilMeetsThreshold = ModConfig.FOOD_EATEN_THRESHOLD - totalFoodEaten;
                toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"spiceoflife.tooltip.food.until.enabled.1"));
                toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)"spiceoflife.tooltip.food.until.enabled.2", (Object[])new Object[]{timesUntilMeetsThreshold, timesUntilMeetsThreshold == 1 ? StatCollector.func_74838_a((String)"spiceoflife.tooltip.times.singular") : StatCollector.func_74838_a((String)"spiceoflife.tooltip.times.plural")}));
            } else {
                int count = FoodTracker.getFoodHistoryCountOf(event.itemStack, event.entityPlayer);
                foodModifier = FoodModifier.getFoodModifier(event.entityPlayer, event.itemStack, FoodValues.get((ItemStack)event.itemStack));
                FoodValues foodValues = FoodValues.get((ItemStack)event.itemStack, (EntityPlayer)event.entityPlayer);
                if (canDiminish && (count > 0 || foodModifier != 1.0f)) {
                    toolTipStringsToAdd.add(0, EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"spiceoflife.tooltip.nutritional.value") + ColorHelper.getRelativeColor(foodModifier, 0.0, 1.0) + df.format(foodModifier * 100.0f) + "%" + (foodValues.hunger == 0 && foodModifier != 0.0f ? EnumChatFormatting.DARK_RED + " (" + foodValues.hunger + " " + StatCollector.func_74838_a((String)"spiceoflife.tooltip.hunger") + ")" : ""));
                }
                if (count > 0) {
                    toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74837_a((String)("spiceoflife.tooltip.eaten.recently" + (ModConfig.USE_TIME_QUEUE ? ".time" : (ModConfig.USE_HUNGER_QUEUE ? ".hunger" : ""))), (Object[])new Object[]{StringHelper.getQuantityDescriptor(count), ModConfig.USE_HUNGER_QUEUE ? df.format((float)ModConfig.FOOD_HISTORY_LENGTH / 2.0f) : Integer.valueOf(ModConfig.FOOD_HISTORY_LENGTH)}));
                } else {
                    toolTipStringsToAdd.add(EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"spiceoflife.tooltip.not.eaten.recently"));
                }
            }
            event.toolTip.addAll(toolTipStringsToAdd);
        }
    }
}

