/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.helpers;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class InventoryHelper {
    public static final Method hopperInsertIntoInventory = ReflectionHelper.findMethod(TileEntityHopper.class, null, (String[])new String[]{"func_145899_c", "c"}, (Class[])new Class[]{IInventory.class, ItemStack.class, Integer.TYPE, Integer.TYPE});

    public static IInventory getInventoryAtLocation(World world, int x, int y, int z) {
        return TileEntityHopper.func_145893_b((World)world, (double)x, (double)y, (double)z);
    }

    public static ItemStack insertStackIntoInventory(ItemStack itemStack, IInventory inventory) {
        return TileEntityHopper.func_145889_a((IInventory)inventory, (ItemStack)itemStack, (int)ForgeDirection.UNKNOWN.ordinal());
    }

    public static ItemStack insertStackIntoInventoryOnce(ItemStack itemStack, IInventory inventory) {
        int originalStackSize = itemStack.field_77994_a;
        for (int l = 0; l < inventory.func_70302_i_(); ++l) {
            try {
                itemStack = (ItemStack)hopperInsertIntoInventory.invoke(null, inventory, itemStack, l, ForgeDirection.UNKNOWN.ordinal());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (itemStack == null || itemStack.field_77994_a != originalStackSize) break;
        }
        if (itemStack != null && itemStack.field_77994_a == 0) {
            itemStack = null;
        }
        return itemStack;
    }

    public static List<Integer> getNonEmptySlotsInInventory(IInventory inventory) {
        ArrayList<Integer> nonEmptySlotIndexes = new ArrayList<Integer>();
        for (int slotNum = 0; slotNum < inventory.func_70302_i_(); ++slotNum) {
            if (inventory.func_70301_a(slotNum) == null) continue;
            nonEmptySlotIndexes.add(slotNum);
        }
        return nonEmptySlotIndexes;
    }

    public static int getRandomNonEmptySlotInInventory(IInventory inventory, Random random) {
        List<Integer> nonEmptySlots = InventoryHelper.getNonEmptySlotsInInventory(inventory);
        if (nonEmptySlots.size() > 0) {
            return nonEmptySlots.get(random.nextInt(nonEmptySlots.size()));
        }
        return 0;
    }

    public static ItemStack removeRandomSingleItemFromInventory(IInventory inventory, Random random) {
        int randomNonEmptySlotIndex = InventoryHelper.getRandomNonEmptySlotInInventory(inventory, random);
        if (inventory.func_70301_a(randomNonEmptySlotIndex) != null) {
            return inventory.func_70298_a(randomNonEmptySlotIndex, 1);
        }
        return null;
    }
}

