/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.network;

import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import squeek.spiceoflife.compat.IByteIO;
import squeek.spiceoflife.foodtracker.FoodEaten;
import squeek.spiceoflife.foodtracker.FoodHistory;
import squeek.spiceoflife.network.PacketBase;

public class PacketFoodHistory
extends PacketBase {
    private FoodHistory foodHistory = null;
    private boolean shouldOverwrite = false;

    public PacketFoodHistory() {
    }

    public PacketFoodHistory(FoodHistory foodHistory) {
        this.foodHistory = foodHistory;
    }

    public PacketFoodHistory(FoodHistory foodHistory, boolean shouldOverwrite) {
        this(foodHistory);
        this.shouldOverwrite = shouldOverwrite;
    }

    public PacketFoodHistory(FoodEaten foodEaten) {
        this.foodHistory = new FoodHistory();
        this.foodHistory.addFood(foodEaten);
    }

    @Override
    public void pack(IByteIO data) {
        if (this.foodHistory == null) {
            return;
        }
        data.writeBoolean(this.shouldOverwrite);
        this.foodHistory.pack(data);
    }

    @Override
    public void unpack(IByteIO data) {
        this.foodHistory = new FoodHistory();
        this.shouldOverwrite = data.readBoolean();
        this.foodHistory.unpack(data);
    }

    @Override
    public PacketBase processAndReply(Side side, EntityPlayer player) {
        FoodHistory foodHistory = FoodHistory.get(player);
        if (this.shouldOverwrite) {
            foodHistory.getHistory().clear();
            foodHistory.ticksActive = this.foodHistory.ticksActive;
        }
        for (FoodEaten foodEaten : this.foodHistory.getHistory()) {
            foodHistory.addFood(foodEaten, !this.shouldOverwrite);
        }
        return null;
    }
}

