/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common;

import com.google.common.base.Optional;
import com.stek101.projectzulu.common.ExperienceRedistributor;
import com.stek101.projectzulu.common.ItemBlacklist;
import com.stek101.projectzulu.common.api.BlockList;
import com.stek101.projectzulu.common.blocks.tombstone.TileEntityTombstone;
import com.stek101.projectzulu.common.core.ObfuscationHelper;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.WorldEvent;

public class DeathGamerules {
    int maxDropXP = 100;
    int percKeptXp = 0;
    int armorDeathDamage = 0;
    int inventoryDeathDamage = 0;
    int hotbarDeathDamage = 0;
    int armorDropDamage = 0;
    int inventoryDropDamage = 0;
    int hotbarDropDamage = 0;
    int armorDropChance = 100;
    int inventoryDropChance = 100;
    int hotbarDropChance = 100;
    int armorMaxDrop = 0;
    int inventoryMaxDrop = 0;
    int hotbarMaxDrop = 0;
    boolean tombstoneOnDeath = true;
    boolean tombstoneAbsorbDrops = true;
    boolean doDropEvent = true;
    boolean keepInventoryDefault = false;
    boolean dropArmorDefault = false;
    boolean dropInventoryDefault = false;
    boolean dropHotbarDefault = false;
    boolean dropXPDefault = false;
    boolean enableDeathRules = true;
    private ExperienceRedistributor redistributor = new ExperienceRedistributor();
    private ItemBlacklist itemBlacklist;

    public DeathGamerules() {
        FMLCommonHandler.instance().bus().register((Object)this.redistributor);
    }

    public DeathGamerules loadConfiguration(File modConfigDirectory) {
        this.itemBlacklist = new ItemBlacklist();
        Configuration config = new Configuration(new File(modConfigDirectory, "/Project Zulu/ProjectZuluConfig.cfg"));
        config.load();
        this.itemBlacklist.loadFromConfig(config);
        this.enableDeathRules = config.get("General Controls", "Activate PZ Death Rules", this.enableDeathRules).getBoolean(this.enableDeathRules);
        this.tombstoneOnDeath = config.get("General Controls", "Drop Tombstone On Death", this.tombstoneOnDeath).getBoolean(this.tombstoneOnDeath);
        this.tombstoneAbsorbDrops = config.get("General Controls", "Tombstone Absorb Drops", this.tombstoneAbsorbDrops).getBoolean(this.tombstoneAbsorbDrops);
        this.doDropEvent = config.get("General Controls", "doDropEvent", this.doDropEvent).getBoolean(this.doDropEvent);
        String category = "General Controls.gamerule_settings";
        this.maxDropXP = config.get(category + ".Experience", "maxDropXP", 100, "Maximum amount XP dropped on Death. The rest is lost if not kept via percKeptXp. 100 is vanilla default").getInt(100);
        this.keepInventoryDefault = config.get(category, "keepInventoryDefault", false, "The Default settings for the keepInventory gamerule").getBoolean(false);
        Property keptXpProperty = config.get(category + ".Experience", "percKeptXp", 0, "Percentage of XP (minus dropped amount) kept with the player on respawn.");
        this.percKeptXp = keptXpProperty.getInt();
        if (this.percKeptXp < 0 || this.percKeptXp > 100) {
            this.percKeptXp = this.percKeptXp < 0 ? 0 : (this.percKeptXp > 100 ? 100 : this.percKeptXp);
            keptXpProperty.set(this.percKeptXp);
        }
        this.dropArmorDefault = config.get(category + ".Armor", "isEnabledDefault", false, "The Default settings for the dropArmor gamerule").getBoolean(false);
        this.dropInventoryDefault = config.get(category + ".Inventory", "isEnabledDefault", false, "The Default settings for the dropInventory gamerule").getBoolean(false);
        this.dropHotbarDefault = config.get(category + ".Hotbar", "isEnabledDefault", false, "The Default settings for the dropHotbar gamerule").getBoolean(false);
        this.dropXPDefault = config.get(category + ".Experience", "isEnabledDefault", false, "The Default settings for the dropXP gamerule").getBoolean(false);
        this.armorDeathDamage = this.handlePropMinMax(config.get(category + ".Armor", "armorDeathDamage", 0, "Percentage of Max durability dealth on Death to armor slot items"), 0, 0, 100);
        this.inventoryDeathDamage = this.handlePropMinMax(config.get(category + ".Inventory", "inventoryDeathDamage", 0, "Percentage of Max durability dealth on Death to inventory slot items"), 0, 0, 100);
        this.hotbarDeathDamage = this.handlePropMinMax(config.get(category + ".Hotbar", "hotbarDeathDamage", 0, "Percentage of Max durability dealth on Death to hotbar slot items"), 0, 0, 100);
        this.armorDropDamage = this.handlePropMinMax(config.get(category + ".Armor", "armorDropDamage", 0, "Percentage of Max durability dealth on Drop to armor slot items"), 0, 0, 100);
        this.inventoryDropDamage = this.handlePropMinMax(config.get(category + ".Inventory", "inventoryDropDamage", 0, "Percentage of Max durability dealth on Drop to inventory slot items"), 0, 0, 100);
        this.hotbarDropDamage = this.handlePropMinMax(config.get(category + ".Hotbar", "hotbarDropDamage", 0, "Percentage of Max durability dealth on Drop to hotbar slot items"), 0, 0, 100);
        this.armorDropChance = this.handlePropMinMax(config.get(category + ".Armor", "armorDropChance", 100, "Chance that each armor slot item will drop on death"), 100, 0, 100);
        this.inventoryDropChance = this.handlePropMinMax(config.get(category + ".Inventory", "inventoryDropChance", 100, "Chance that each inventory slot item will drop on death"), 100, 0, 100);
        this.hotbarDropChance = this.handlePropMinMax(config.get(category + ".Hotbar", "hotbarDropChance", 100, "Chance that each hotbar slot item will drop on death"), 100, 0, 100);
        this.armorMaxDrop = this.handlePropMinMax(config.get(category + ".Armor", "armorMaxDrop", 0, "Max number of armor slot items that can drop on death."), 0, 0, null);
        this.inventoryMaxDrop = this.handlePropMinMax(config.get(category + ".Inventory", "inventoryMaxDrop", 0, "Max number of inventory slot items that can drop on death"), 0, 0, null);
        this.hotbarMaxDrop = this.handlePropMinMax(config.get(category + ".Hotbar", "hotbarMaxDrop", 0, "Max number of hotbar slot items that can drop on death"), 0, 0, null);
        config.save();
        return this;
    }

    private int handlePropMinMax(Property prop, int value, Integer min, Integer max) {
        value = prop.getInt(value);
        if (min != null && value < min) {
            prop.set(min.intValue());
            value = min;
        } else if (max != null && value > max) {
            prop.set(max.intValue());
            value = max;
        }
        return value;
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        GameRules gameRule = event.world.func_82736_K();
        if (this.enableDeathRules) {
            ProjectZuluLog.info("Project Zulu : Death Rules are ENABLED.", new Object[0]);
            gameRule.func_82764_b("keepInventory", Boolean.toString(this.keepInventoryDefault));
            gameRule.func_82764_b("dropInventory", String.valueOf(this.dropInventoryDefault));
            gameRule.func_82764_b("dropHotbar", String.valueOf(this.dropHotbarDefault));
            gameRule.func_82764_b("dropArmor", String.valueOf(this.dropArmorDefault));
            gameRule.func_82764_b("dropXP", String.valueOf(this.dropXPDefault));
        } else {
            ProjectZuluLog.warning("Project Zulu : Death Rules are DISABLED.", new Object[0]);
        }
    }

    private boolean createGameruleIfAbsent(GameRules gameRule, String gameruleName, boolean value) {
        boolean added = false;
        if (!gameRule.func_82765_e(gameruleName)) {
            gameRule.func_82769_a(gameruleName, Boolean.toString(value));
            added = true;
        }
        ProjectZuluLog.info("Gamerule %s is set to %s", gameruleName, gameRule.func_82766_b(gameruleName));
        return added;
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        block15: {
            ArrayList<ItemStack> itemsToDrop;
            int xpDropped;
            EntityPlayer player;
            block16: {
                block17: {
                    TileEntityTombstone tombstone;
                    block18: {
                        ArrayList drops = event.entity.capturedDrops;
                        int minDistance = 0;
                        Optional<? extends Block> tombStoneBlock = BlockList.tombstone;
                        if (!this.enableDeathRules || !(event.entity instanceof EntityPlayerMP)) break block15;
                        GameRules gameRules = event.entity.field_70170_p.func_82736_K();
                        boolean dropInventory = gameRules.func_82766_b("dropInventory");
                        boolean dropHotbar = gameRules.func_82766_b("dropHotbar");
                        boolean dropArmor = gameRules.func_82766_b("dropArmor");
                        boolean dropXP = gameRules.func_82766_b("dropXP");
                        player = (EntityPlayer)event.entity;
                        if (!(dropInventory || dropHotbar || dropArmor || dropXP)) {
                            return;
                        }
                        xpDropped = 0;
                        if (dropXP && !player.field_70170_p.field_72995_K) {
                            int keptXp;
                            if (this.maxDropXP > 100 && this.maxDropXP < 0) {
                                ProjectZuluLog.warning("The value of MaxDropXP is INVALID. Resetting to default value of 100", new Object[0]);
                                this.maxDropXP = 100;
                            }
                            if (this.percKeptXp > 100 && this.percKeptXp < 0) {
                                ProjectZuluLog.warning("The value of percKeptXp is INVALID. Resetting to default value of 0", new Object[0]);
                                this.percKeptXp = 0;
                            }
                            this.redistributor.addExperience(player, (keptXp = (int)((float)(player.field_71067_cb - (xpDropped = (int)((float)player.field_71067_cb * ((float)this.maxDropXP / 100.0f)))) * ((float)this.percKeptXp / 100.0f))) >= 0 ? keptXp : 0);
                            player.field_71068_ca = 0;
                            player.field_71067_cb = 0;
                            player.field_71106_cc = 0.0f;
                        }
                        itemsToDrop = new ArrayList<ItemStack>();
                        if (dropArmor) {
                            itemsToDrop.addAll(this.dropArmor(player));
                        }
                        if (dropInventory) {
                            itemsToDrop.addAll(this.dropInventory(player));
                        }
                        if (dropHotbar) {
                            itemsToDrop.addAll(this.dropHotbar(player));
                        }
                        boolean isCancelled = false;
                        if (!tombStoneBlock.isPresent()) break block16;
                        String tombmsg = "";
                        if (event.source.func_94541_c()) {
                            minDistance = 10;
                        }
                        DamageSource cfr_ignored_0 = event.source;
                        if (DamageSource.field_76371_c != null) {
                            minDistance = 3;
                        }
                        TileEntityTombstone tileEntityTombstone = tombstone = this.tombstoneOnDeath ? this.placeTombstone(player, minDistance) : null;
                        if (tombstone != null) {
                            tombstone.setSignString("HERE LIES " + event.source.func_151519_b((EntityLivingBase)((EntityPlayer)event.entity)).func_150261_e().toUpperCase());
                        }
                        if (isCancelled) break block17;
                        if (!this.tombstoneAbsorbDrops || tombstone == null) break block18;
                        for (int i = 0; i < itemsToDrop.size(); ++i) {
                            tombstone.addDrop((ItemStack)itemsToDrop.get(i));
                        }
                        tombstone.experience = xpDropped;
                        break block15;
                    }
                    if ((this.tombstoneAbsorbDrops || tombstone == null) && (!this.tombstoneAbsorbDrops || tombstone != null)) break block15;
                    if (!itemsToDrop.isEmpty()) {
                        this.dropItems(player, itemsToDrop);
                    }
                    while (xpDropped > 0) {
                        int j = EntityXPOrb.func_70527_a((int)xpDropped);
                        xpDropped -= j;
                        player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, j));
                    }
                    break block15;
                }
                System.out.println("Tombstone drop event cancelled");
                ProjectZuluLog.warning("Player drop event was cancelled, so items will not be dropped per convention.Results may not desireable, consider disabling 'doDropEvent' in the config.", new Object[0]);
                break block15;
            }
            if (!itemsToDrop.isEmpty()) {
                this.dropItems(player, itemsToDrop);
            }
            while (xpDropped > 0) {
                int j = EntityXPOrb.func_70527_a((int)xpDropped);
                xpDropped -= j;
                player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, j));
            }
        }
    }

    private void dropItems(EntityPlayer player, List<ItemStack> drops) {
        for (ItemStack itemDrop : drops) {
            player.field_71071_by.field_70458_d.func_71019_a(itemDrop, true);
        }
    }

    private PlayerDropsEvent createPlayerDropEvent(EntityPlayer player, DamageSource damageSource, ArrayList<EntityItem> drops) {
        int recentlyHit;
        try {
            recentlyHit = ObfuscationHelper.getCatchableFieldFromReflection("field_70718_bc", EntityLivingBase.class, player, Integer.class);
        }
        catch (NoSuchFieldException e) {
            recentlyHit = ObfuscationHelper.getFieldFromReflection("recentlyHit", EntityLivingBase.class, (Object)player, Integer.class);
        }
        return new PlayerDropsEvent(player, damageSource, player.capturedDrops, recentlyHit > 0);
    }

    private TileEntityTombstone placeTombstone(EntityPlayer player, int minDistance) {
        Optional<ChunkCoordinates> chunkCoordinate = this.findValidTombstoneLocation(player, minDistance);
        if (chunkCoordinate.isPresent()) {
            player.field_70170_p.func_147449_b(((ChunkCoordinates)chunkCoordinate.get()).field_71574_a, ((ChunkCoordinates)chunkCoordinate.get()).field_71572_b, ((ChunkCoordinates)chunkCoordinate.get()).field_71573_c, (Block)BlockList.tombstone.get());
            TileEntity tileEntity = player.field_70170_p.func_147438_o(((ChunkCoordinates)chunkCoordinate.get()).field_71574_a, ((ChunkCoordinates)chunkCoordinate.get()).field_71572_b, ((ChunkCoordinates)chunkCoordinate.get()).field_71573_c);
            StringBuilder sb = new StringBuilder();
            sb.append("A tombstone has been set to mark the 'passing' of ").append(player.func_70005_c_()).append(" at [");
            sb.append(((ChunkCoordinates)chunkCoordinate.get()).field_71574_a).append(", ");
            sb.append(((ChunkCoordinates)chunkCoordinate.get()).field_71572_b).append(", ");
            sb.append(((ChunkCoordinates)chunkCoordinate.get()).field_71573_c).append("]");
            player.func_145747_a((IChatComponent)new ChatComponentText(sb.toString()));
            if (tileEntity != null && tileEntity instanceof TileEntityTombstone) {
                ProjectZuluLog.debug(Level.INFO, sb.toString(), new Object[0]);
                return (TileEntityTombstone)tileEntity;
            }
        }
        ProjectZuluLog.warning("Failed to find location to place tombstone at player location {X:%s, Y:%s, Z:%s}", player.field_70165_t, player.field_70163_u, player.field_70161_v);
        return null;
    }

    private Optional<ChunkCoordinates> findValidTombstoneLocation(EntityPlayer player, int minDistance) {
        int maxRadius = 100;
        for (int radius = minDistance; radius < 100; ++radius) {
            ArrayList<ChunkCoordinates> validLocations = new ArrayList<ChunkCoordinates>();
            validLocations.addAll(this.searchXPlaneAt(-radius, radius, player));
            validLocations.addAll(this.searchXPlaneAt(radius, radius, player));
            validLocations.addAll(this.searchZPlaneAt(-radius, radius, player));
            validLocations.addAll(this.searchZPlaneAt(radius, radius, player));
            validLocations.addAll(this.searchYPlaneAt(-radius, radius, player));
            validLocations.addAll(this.searchYPlaneAt(radius, radius, player));
            ChunkCoordinates closestPoint = null;
            float bestDistance = 0.0f;
            for (ChunkCoordinates chunkCoordinates : validLocations) {
                if (closestPoint != null) {
                    float distance = chunkCoordinates.func_71569_e((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    if (!(distance < bestDistance)) continue;
                    bestDistance = distance;
                    closestPoint = chunkCoordinates;
                    continue;
                }
                closestPoint = chunkCoordinates;
                bestDistance = closestPoint.func_71569_e((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
            if (closestPoint == null) continue;
            return Optional.of(closestPoint);
        }
        return Optional.absent();
    }

    private List<ChunkCoordinates> searchXPlaneAt(int xOffset, int radius, EntityPlayer player) {
        ArrayList<ChunkCoordinates> matches = new ArrayList<ChunkCoordinates>();
        for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
            for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                ChunkCoordinates chunkCoordinates = new ChunkCoordinates((int)(player.field_70165_t + (double)xOffset), (int)(player.field_70163_u + (double)yOffset), (int)(player.field_70161_v + (double)zOffset));
                if (!this.isLocationValid(player, chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c)) continue;
                matches.add(chunkCoordinates);
            }
        }
        return matches;
    }

    private List<ChunkCoordinates> searchZPlaneAt(int zOffset, int radius, EntityPlayer player) {
        ArrayList<ChunkCoordinates> matches = new ArrayList<ChunkCoordinates>();
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int yOffset = -radius; yOffset <= radius; ++yOffset) {
                ChunkCoordinates chunkCoordinates = new ChunkCoordinates((int)(player.field_70165_t + (double)xOffset), (int)(player.field_70163_u + (double)yOffset), (int)(player.field_70161_v + (double)zOffset));
                if (!this.isLocationValid(player, chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c)) continue;
                matches.add(chunkCoordinates);
            }
        }
        return matches;
    }

    private List<ChunkCoordinates> searchYPlaneAt(int yOffset, int radius, EntityPlayer player) {
        ArrayList<ChunkCoordinates> matches = new ArrayList<ChunkCoordinates>();
        for (int xOffset = -radius; xOffset <= radius; ++xOffset) {
            for (int zOffset = -radius; zOffset <= radius; ++zOffset) {
                ChunkCoordinates chunkCoordinates = new ChunkCoordinates((int)(player.field_70165_t + (double)xOffset), (int)(player.field_70163_u + (double)yOffset), (int)(player.field_70161_v + (double)zOffset));
                if (!this.isLocationValid(player, chunkCoordinates.field_71574_a, chunkCoordinates.field_71572_b, chunkCoordinates.field_71573_c)) continue;
                matches.add(chunkCoordinates);
            }
        }
        return matches;
    }

    private boolean isLocationValid(EntityPlayer player, int posX, int posY, int posZ) {
        return (player.field_70170_p.func_147437_c(posX, posY, posZ) || player.field_70170_p.func_147439_a(posX, posY, posZ).func_149688_o().func_76222_j()) && player.field_70170_p.func_147439_a(posX, posY - 1, posZ).func_149662_c() && !player.field_70170_p.func_147439_a(posX, posY, posZ).func_149688_o().equals(Material.field_151586_h) && !player.field_70170_p.func_147439_a(posX, posY, posZ).func_149688_o().equals(Material.field_151587_i);
    }

    private List<ItemStack> dropArmor(EntityPlayer player) {
        ArrayList<ItemStack> itemsToDrop = new ArrayList<ItemStack>();
        if (this.armorMaxDrop > 4 || this.armorMaxDrop < 0) {
            ProjectZuluLog.warning("The value of armorMaxdrop is INVALID. Resetting to a default value of 4", new Object[0]);
            this.armorMaxDrop = 4;
        }
        int[] placeArray = new int[player.field_71071_by.field_70460_b.length];
        for (int i = 0; i < placeArray.length; ++i) {
            placeArray[i] = i;
        }
        this.shuffleArray(placeArray, player.field_70170_p.field_73012_v);
        int countDrops = 0;
        for (int i = 0; i < placeArray.length; ++i) {
            boolean itemDestroyed;
            int slot = placeArray[i];
            ItemStack itemStack = player.field_71071_by.field_70460_b[slot];
            if (itemStack == null || this.itemBlacklist.isItemBlacklisted(itemStack)) continue;
            boolean shouldDrop = false;
            if ((this.armorMaxDrop == 0 || countDrops < this.armorMaxDrop) && this.armorDropChance - player.field_70170_p.field_73012_v.nextInt(100) >= 1) {
                shouldDrop = true;
            }
            if (!shouldDrop) continue;
            int percentDamage = shouldDrop ? this.armorDeathDamage + this.armorDropDamage : this.armorDeathDamage;
            percentDamage = percentDamage > 100 ? 100 : percentDamage;
            itemStack.func_96631_a(itemStack.func_77958_k() * percentDamage / 100, player.field_70170_p.field_73012_v);
            boolean bl = itemDestroyed = itemStack.func_77984_f() && itemStack.func_77960_j() > itemStack.func_77958_k();
            if (itemDestroyed) {
                player.field_71071_by.field_70460_b[slot] = null;
            }
            if (!itemDestroyed) {
                itemsToDrop.add(itemStack);
            }
            player.field_71071_by.field_70460_b[slot] = null;
            ++countDrops;
        }
        return itemsToDrop;
    }

    private List<ItemStack> dropInventory(EntityPlayer player) {
        ArrayList<ItemStack> itemsToDrop = new ArrayList<ItemStack>();
        if (this.inventoryMaxDrop > 27 || this.inventoryMaxDrop < 0) {
            ProjectZuluLog.warning("The value of inventoryMaxDrop is INVALID. Resetting to a default value of 4", new Object[0]);
            this.inventoryMaxDrop = 27;
        }
        if (player.field_71071_by.field_70462_a.length > 8) {
            int[] placeArray = new int[player.field_71071_by.field_70462_a.length - 9];
            for (int i = 0; i < placeArray.length; ++i) {
                placeArray[i] = i + 9;
            }
            this.shuffleArray(placeArray, player.field_70170_p.field_73012_v);
            int countDrops = 0;
            for (int i = 0; i < placeArray.length; ++i) {
                boolean itemDestroyed;
                int slot = placeArray[i];
                ItemStack itemStack = player.field_71071_by.field_70462_a[slot];
                if (itemStack == null || this.itemBlacklist.isItemBlacklisted(itemStack)) continue;
                boolean shouldDrop = false;
                if ((this.inventoryMaxDrop == 0 || countDrops < this.inventoryMaxDrop) && this.inventoryDropChance - player.field_70170_p.field_73012_v.nextInt(100) >= 1) {
                    shouldDrop = true;
                }
                if (!shouldDrop) continue;
                int percentDamage = shouldDrop ? this.inventoryDeathDamage + this.inventoryDropDamage : this.inventoryDeathDamage;
                percentDamage = percentDamage > 100 ? 100 : percentDamage;
                itemStack.func_96631_a(itemStack.func_77958_k() * percentDamage / 100, player.field_70170_p.field_73012_v);
                boolean bl = itemDestroyed = itemStack.func_77984_f() && itemStack.func_77960_j() > itemStack.func_77958_k();
                if (itemDestroyed) {
                    player.field_71071_by.field_70462_a[slot] = null;
                }
                if (!itemDestroyed) {
                    itemsToDrop.add(itemStack);
                }
                player.field_71071_by.field_70462_a[slot] = null;
                ++countDrops;
            }
        }
        return itemsToDrop;
    }

    private List<ItemStack> dropHotbar(EntityPlayer player) {
        ArrayList<ItemStack> itemsToDrop = new ArrayList<ItemStack>();
        if (this.hotbarMaxDrop > 9 || this.hotbarMaxDrop < 0) {
            ProjectZuluLog.warning("The value of hotbarMaxdrop is INVALID. Resetting to a default value of 9", new Object[0]);
            this.hotbarMaxDrop = 9;
        }
        int inventorySize = player.field_71071_by.field_70462_a.length > 9 ? 9 : player.field_71071_by.field_70462_a.length;
        int[] placeArray = new int[inventorySize];
        for (int i = 0; i < placeArray.length; ++i) {
            placeArray[i] = i;
        }
        this.shuffleArray(placeArray, player.field_70170_p.field_73012_v);
        int countDrops = 0;
        for (int i = 0; i < placeArray.length; ++i) {
            boolean itemDestroyed;
            int slot = placeArray[i];
            ItemStack itemStack = player.field_71071_by.field_70462_a[slot];
            if (itemStack == null || this.itemBlacklist.isItemBlacklisted(itemStack)) continue;
            boolean shouldDrop = false;
            if ((this.hotbarMaxDrop == 0 || countDrops < this.hotbarMaxDrop) && this.hotbarDropChance - player.field_70170_p.field_73012_v.nextInt(100) >= 1) {
                shouldDrop = true;
            }
            if (!shouldDrop || itemStack == null) continue;
            int percentDamage = shouldDrop ? this.hotbarDeathDamage + this.hotbarDropDamage : this.hotbarDeathDamage;
            percentDamage = percentDamage > 100 ? 100 : percentDamage;
            itemStack.func_96631_a(itemStack.func_77958_k() * percentDamage / 100, player.field_70170_p.field_73012_v);
            boolean bl = itemDestroyed = itemStack.func_77984_f() && itemStack.func_77960_j() > itemStack.func_77958_k();
            if (itemDestroyed) {
                player.field_71071_by.field_70462_a[slot] = null;
            }
            if (!itemDestroyed) {
                itemsToDrop.add(itemStack);
            }
            player.field_71071_by.field_70462_a[slot] = null;
            ++countDrops;
        }
        return itemsToDrop;
    }

    private void shuffleArray(int[] array, Random random) {
        for (int i = array.length - 1; i >= 0; --i) {
            int index = random.nextInt(i + 1);
            int a = array[index];
            array[index] = array[i];
            array[i] = a;
        }
    }
}

