/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common;

import com.stek101.projectzulu.common.blocks.util.StringHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ItemBlacklist {
    private List<Rule> blacklist;

    public void loadFromConfig(Configuration config) {
        String[] itemStringEntries;
        this.blacklist = new ArrayList<Rule>();
        Property property = config.get("General Controls", "Tombstone drop blacklist", "");
        for (String stringEntry : itemStringEntries = property.getString().split(",")) {
            String[] entryParts = stringEntry.split(":");
            if (entryParts.length < 1 || stringEntry.trim().equals("")) continue;
            String itemID = entryParts[0];
            if (entryParts.length >= 2) {
                int minMeta;
                String[] metaRangeParts = entryParts[1].split("-");
                if (metaRangeParts.length == 1) {
                    if ("*".equals(metaRangeParts[0])) {
                        this.blacklist.add(new ItemIdMatch(itemID));
                        continue;
                    }
                    minMeta = StringHelper.parseInteger(metaRangeParts[0], "0123456789");
                    this.blacklist.add(new ItemMetaMatch(itemID, minMeta));
                    continue;
                }
                minMeta = StringHelper.parseInteger(metaRangeParts[0], "0123456789");
                int maxMeta = StringHelper.parseInteger(metaRangeParts[1], "0123456789");
                this.blacklist.add(new ItemMetaMatch(itemID, minMeta, maxMeta));
                continue;
            }
            this.blacklist.add(new ItemIdMatch(itemID));
        }
    }

    public boolean isEmpty() {
        return this.blacklist.isEmpty();
    }

    public boolean isItemBlacklisted(ItemStack stack) {
        for (Rule rule : this.blacklist) {
            if (!rule.isMatch(stack)) continue;
            return true;
        }
        return false;
    }

    private static class ItemMetaMatch
    extends ItemIdMatch {
        public final int minItemDamage;
        public final int maxItemDamage;

        public ItemMetaMatch(String itemId, int minItemDamage) {
            this(itemId, minItemDamage, minItemDamage);
        }

        public ItemMetaMatch(String itemId, int minItemDamage, int maxItemDamage) {
            super(itemId);
            this.minItemDamage = minItemDamage;
            this.maxItemDamage = maxItemDamage;
        }

        @Override
        public boolean isMatch(ItemStack itemStack) {
            if (super.isMatch(itemStack)) {
                if (this.minItemDamage <= this.maxItemDamage) {
                    return itemStack.func_77960_j() <= this.maxItemDamage && itemStack.func_77960_j() >= this.minItemDamage;
                }
                return itemStack.func_77960_j() >= this.minItemDamage || itemStack.func_77960_j() <= this.maxItemDamage;
            }
            return false;
        }
    }

    private static class ItemIdMatch
    implements Rule {
        public final String itemId;

        public ItemIdMatch(String itemId) {
            this.itemId = itemId;
        }

        @Override
        public boolean isMatch(ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            return this.itemId.equals(Item.field_150901_e.func_148750_c((Object)itemStack.func_77973_b()));
        }
    }

    private static interface Rule {
        public boolean isMatch(ItemStack var1);
    }
}

