/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.api;

import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;

public class CustomMobData {
    public String mobName = "";
    public final HashMap<String, Object> customData = new HashMap();
    public int secondarySpawnRate = 100;
    public boolean reportSpawningInLog = false;
    public boolean shouldDespawn = true;
    public int maxSpawnInChunk = 4;
    public EnumCreatureType creatureType;
    public EnumCreatureType spawnType;
    public EntityProperties entityProperties;
    public int minDropNum = 0;
    public int maxDropNum = 0;
    private List<WeightedItemStack> lootItems = new ArrayList<WeightedItemStack>();

    public CustomMobData(String mobName) {
        this.mobName = mobName;
    }

    public void addLootToMob(ItemStack itemStack, int weight) {
        this.lootItems.add(new WeightedItemStack(Item.field_150901_e.func_148750_c((Object)itemStack.func_77973_b()), itemStack.func_77960_j(), itemStack.field_77994_a, weight));
    }

    public void addLootToMob(String itemID, int itemDamage, int stackSize, int weight) {
        this.lootItems.add(new WeightedItemStack(itemID, itemDamage, stackSize, weight));
    }

    public ItemStack getLootItem(Random rand) {
        if (this.lootItems != null && !this.lootItems.isEmpty()) {
            WeightedItemStack stack = (WeightedItemStack)WeightedRandom.func_76271_a((Random)rand, this.lootItems);
            Item item = (Item)Item.field_150901_e.func_82594_a(stack.itemID);
            if (item != null) {
                return new ItemStack(item, stack.stackSize, stack.itemDamage);
            }
        }
        return null;
    }

    public Collection<ItemStack> getLoot(Random rand, int extraDrops) {
        int numberOfItems = this.minDropNum + rand.nextInt(1 + this.maxDropNum - this.minDropNum + extraDrops);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(numberOfItems);
        for (int i = 0; i < numberOfItems; ++i) {
            ItemStack stack = this.getLootItem(rand);
            if (stack == null) continue;
            items.add(stack);
        }
        return items;
    }

    public static class WeightedItemStack
    extends WeightedRandom.Item {
        public final String itemID;
        public final int itemDamage;
        public final int stackSize;

        public WeightedItemStack(String itemID, int itemDamage, int stackSize, int weight) {
            super(weight);
            this.itemID = itemID;
            this.itemDamage = itemDamage;
            this.stackSize = stackSize;
        }
    }
}

