/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.blocks.tombstone;

import com.stek101.projectzulu.common.ProjectZulu_Core;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityTombstone
extends TileEntity {
    private ArrayList<ItemStack> deathItems = new ArrayList();
    public int experience = 0;
    private EntityXPOrb xpOrb = null;
    public String[] signText = new String[7];
    public final int maxLines = 7;
    public final int maxcharPerLine = 13;
    public int lineBeingEdited = -1;
    private boolean isEditable = true;

    public EntityXPOrb getEntityOrb() {
        if (this.hasDrops()) {
            if (this.xpOrb == null) {
                this.xpOrb = new EntityXPOrb(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(5) + 1);
            }
            return this.xpOrb;
        }
        return null;
    }

    public boolean addDrop(ItemStack itemDrop) {
        return this.deathItems.add(itemDrop);
    }

    public boolean hasDrops() {
        return !this.deathItems.isEmpty() || this.experience > 0;
    }

    public int getSizeInventory() {
        return this.deathItems.size();
    }

    public ItemStack getStackInSlot(int slotNum) {
        return this.deathItems.get(slotNum);
    }

    public void giveItemsToPlayer(EntityPlayer player) {
        player.func_71023_q(this.experience);
        this.experience = 0;
        Iterator<ItemStack> unSortIterator = this.deathItems.iterator();
        boolean itemAdded = true;
        while (unSortIterator.hasNext() && itemAdded) {
            ItemStack deathItem = unSortIterator.next();
            itemAdded = player.field_71071_by.func_70441_a(deathItem);
            if (!itemAdded) continue;
            unSortIterator.remove();
        }
    }

    public int dropXP() {
        int droppedXP = this.experience;
        this.experience = 0;
        return droppedXP;
    }

    public void spawnItemsNearPlayer(World world, int par1, int par2, int par3) {
        Random rand = new Random();
        EntityPlayer player = ProjectZulu_Core.proxy.getClientPlayer();
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        Iterator<ItemStack> unSortIterator = this.deathItems.iterator();
        while (unSortIterator.hasNext()) {
            ItemStack deathItem = unSortIterator.next();
            if (side != Side.SERVER) continue;
            double xrand = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double yrand = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double zrand = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem itemDrop = new EntityItem(world, (double)par1 + xrand, (double)par2 + yrand, (double)par3 + zrand, deathItem);
            itemDrop.field_145804_b = 10;
            world.func_72838_d((Entity)itemDrop);
            unSortIterator.remove();
        }
    }

    public TileEntityTombstone() {
        for (int i = 0; i < this.signText.length; ++i) {
            this.signText[i] = "";
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        for (int i = 0; i < this.signText.length; ++i) {
            if (this.signText[i].length() <= 0) continue;
            tagCompound.func_74778_a("Text" + (i + 1), this.signText[i]);
        }
        tagCompound.func_74768_a("Experience", this.experience);
        this.addItemsToCompound(tagCompound, "DeathItems", this.deathItems);
    }

    private void addItemsToCompound(NBTTagCompound tileCompound, String itemTagName, List<ItemStack> items) {
        NBTTagList itemsTag = new NBTTagList();
        for (ItemStack itemStack : items) {
            NBTTagCompound tag = new NBTTagCompound();
            itemStack.func_77955_b(tag);
            itemsTag.func_74742_a((NBTBase)tag);
        }
        tileCompound.func_74782_a(itemTagName, (NBTBase)itemsTag);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        this.isEditable = false;
        super.func_145839_a(tagCompound);
        for (int i = 0; i < this.signText.length; ++i) {
            this.signText[i] = tagCompound.func_74779_i("Text" + (i + 1));
            if (this.signText[i].length() <= 13) continue;
            this.signText[i] = this.signText[i].substring(0, 13);
        }
        this.experience = tagCompound.func_74764_b("Experience") ? tagCompound.func_74762_e("Experience") : 0;
        this.deathItems = this.readItemsFromCompound(tagCompound, "DeathItems");
    }

    public ArrayList<ItemStack> readItemsFromCompound(NBTTagCompound tileCompound, String itemTagName) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (tileCompound.func_74764_b(itemTagName)) {
            NBTTagList itemsTag = (NBTTagList)tileCompound.func_74781_a(itemTagName);
            for (int i = 0; i < itemsTag.func_74745_c(); ++i) {
                ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)itemsTag.func_150305_b(i));
                if (itemStack == null) continue;
                items.add(itemStack);
            }
        }
        return items;
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 4, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEditable(boolean par1) {
        this.isEditable = par1;
    }

    public void setSignString(String inputString) {
        String[] words = inputString.split(" ");
        int startWord = 0;
        block0: for (int currentLine = 0; currentLine < this.signText.length; ++currentLine) {
            StringBuilder currentLineText = new StringBuilder(13);
            for (int i = startWord; i < words.length; ++i) {
                String currentWord = this.getFilteredWord(words[i]);
                if (currentLineText.length() + (currentLineText.length() != 0 ? 1 : 0) + currentWord.length() <= 13) {
                    if (currentLineText.length() != 0) {
                        currentLineText.append(" ");
                    }
                    currentLineText.append(currentWord);
                    if (i + 1 < words.length) continue;
                    this.signText[currentLine] = this.getFilteredWord(currentLineText.toString());
                    currentLineText = new StringBuilder(13);
                    startWord = i + 1;
                    continue block0;
                }
                this.signText[currentLine] = this.getFilteredWord(currentLineText.toString());
                currentLineText = new StringBuilder(13);
                startWord = i;
                continue block0;
            }
        }
    }

    private String getFilteredWord(String word) {
        return word.length() > 13 ? word.substring(0, 11).concat(".") : word;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }
}

