/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core;

import com.stek101.projectzulu.common.core.entitydeclaration.EntityDeclaration;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;

public enum CustomEntityManager {
    INSTANCE;

    private ArrayList<EntityDeclaration> entities = new ArrayList();

    public void addEntity(EntityDeclaration ... entity) {
        for (EntityDeclaration entityDeclaration : entity) {
            this.entities.add(entityDeclaration);
        }
    }

    public void loadCreaturesFromConfig(File configDirectory) {
        Configuration config = new Configuration(new File(configDirectory, "/Project Zulu/ProjectZuluMobBiomeConfig.cfg"));
        config.load();
        for (EntityDeclaration entity : this.entities) {
            entity.loadCreaturesFromConfig(config);
        }
        config.save();
    }

    public void loadBiomesFromConfig(File configDirectory) {
        Configuration config = new Configuration(new File(configDirectory, "/Project Zulu/ProjectZuluMobBiomeConfig.cfg"));
        config.load();
        for (EntityDeclaration entity : this.entities) {
            entity.loadBiomesFromConfig(config);
        }
        config.save();
    }

    public void registerEntities(File configDirectory) {
        for (EntityDeclaration entity : this.entities) {
            if (!entity.shouldExist()) continue;
            entity.registerEntity();
            entity.registerEgg();
            entity.loadCustomMobData(configDirectory);
        }
    }

    public void addSpawns() {
        for (EntityDeclaration entity : this.entities) {
            if (!entity.shouldExist()) continue;
            entity.addSpawn();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModelsAndRender() {
        for (EntityDeclaration entity : this.entities) {
            if (!entity.shouldExist()) continue;
            entity.registerModelAndRender();
        }
    }
}

