/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core;

import com.google.common.base.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class OptionalItemStack {
    private OptionalType type = OptionalType.BLOCK;
    private Optional itemBlock;
    private int meta;
    private int stackSize;

    public OptionalItemStack(Optional<?> itemBlock) {
        this(itemBlock, 1, 0);
    }

    public OptionalItemStack(Optional<?> itemBlock, int stackSize) {
        this(itemBlock, stackSize, 0);
    }

    public OptionalItemStack(Optional<?> itemBlock, int stackSize, int meta) {
        this.itemBlock = itemBlock;
        this.meta = meta;
        this.stackSize = stackSize;
        if (itemBlock.isPresent()) {
            if (itemBlock.get() instanceof Item) {
                this.type = OptionalType.ITEM;
            } else if (itemBlock.get() instanceof Block) {
                this.type = OptionalType.BLOCK;
            } else if (itemBlock.get() instanceof String) {
                this.type = OptionalType.OREDIC;
            }
        } else {
            itemBlock = Optional.absent();
        }
    }

    public OptionalItemStack(Item itemBlock) {
        this(itemBlock, 1, 0);
    }

    public OptionalItemStack(Item itemBlock, int stackSize) {
        this(itemBlock, stackSize, 0);
    }

    public OptionalItemStack(Item itemBlock, int stackSize, int meta) {
        this(Optional.of((Object)itemBlock), stackSize, meta, OptionalType.ITEM);
    }

    public OptionalItemStack(Block itemBlock) {
        this(itemBlock, 1, 0);
    }

    public OptionalItemStack(Block itemBlock, int stackSize) {
        this(itemBlock, stackSize, 0);
    }

    public OptionalItemStack(Block itemBlock, int stackSize, int meta) {
        this(Optional.of((Object)itemBlock), stackSize, meta, OptionalType.BLOCK);
    }

    public OptionalItemStack(String itemBlock) {
        this(itemBlock, 1, 0);
    }

    public OptionalItemStack(String itemBlock, int stackSize) {
        this(itemBlock, stackSize, 0);
    }

    public OptionalItemStack(String itemBlock, int stackSize, int meta) {
        this(Optional.of((Object)itemBlock), stackSize, meta, OptionalType.OREDIC);
    }

    public OptionalItemStack(Optional<?> itemBlock, OptionalType type) {
        this(itemBlock, 1, 0, type);
    }

    public OptionalItemStack(Optional<?> itemBlock, int stackSize, OptionalType type) {
        this(itemBlock, stackSize, 0, type);
    }

    public OptionalItemStack(Optional<?> itemBlock, int stackSize, int meta, OptionalType type) {
        this.itemBlock = itemBlock;
        this.meta = meta;
        this.stackSize = stackSize;
        this.type = type;
    }

    public boolean isPresent() {
        return this.itemBlock != null && this.itemBlock.isPresent();
    }

    public ItemStack createItemStack() {
        switch (this.type) {
            case BLOCK: {
                return new ItemStack((Block)this.itemBlock.get(), this.stackSize, this.meta);
            }
            case ITEM: {
                return new ItemStack((Item)this.itemBlock.get(), this.stackSize, this.meta);
            }
        }
        throw new IllegalStateException("Cannot create ItemStack for OptionalType");
    }

    public Object createRecipeObject() {
        switch (this.type) {
            case BLOCK: 
            case ITEM: {
                return this.createItemStack();
            }
            case OREDIC: {
                return this.itemBlock.get();
            }
        }
        throw new IllegalStateException();
    }

    static enum OptionalType {
        BLOCK,
        ITEM,
        OREDIC;

    }
}

