/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core.entitydeclaration;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.core.ConfigHelper;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.core.entitydeclaration.EggableDeclaration;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnEntry;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public abstract class SpawnableDeclaration
extends EggableDeclaration {
    protected int spawnRate;
    protected boolean useGlobalSpawn = false;
    protected int secondarySpawnRate;
    protected int minInChunk;
    protected int maxInChunk;
    protected EnumCreatureType spawnType;
    private ArrayList<SpawnEntry> biomesToSpawn = new ArrayList();

    protected SpawnableDeclaration(String mobName, int entityID, Class mobClass, EnumCreatureType creatureType) {
        super(mobName, entityID, mobClass, creatureType);
        this.spawnType = creatureType;
    }

    protected void setSpawnProperties(int spawnRate, int secondarySpawnRate, int minInChunk, int maxInChunk) {
        this.spawnRate = spawnRate;
        this.secondarySpawnRate = secondarySpawnRate;
        this.minInChunk = minInChunk;
        this.maxInChunk = maxInChunk;
    }

    @Override
    public void loadCreaturesFromConfig(Configuration config) {
        super.loadCreaturesFromConfig(config);
        this.spawnRate = config.get("MOB CONTROLS." + this.mobName, this.mobName.toLowerCase() + " SpawnRate", this.spawnRate).getInt(this.spawnRate);
        this.secondarySpawnRate = config.get("MOB CONTROLS." + this.mobName, this.mobName.toLowerCase() + " SecondarySpawnRate", this.secondarySpawnRate).getInt(this.secondarySpawnRate);
        this.minInChunk = config.get("MOB CONTROLS." + this.mobName, this.mobName.toLowerCase() + " minInChunk", this.minInChunk).getInt(this.minInChunk);
        this.maxInChunk = config.get("MOB CONTROLS." + this.mobName, this.mobName.toLowerCase() + " maxInChunk", this.maxInChunk).getInt(this.maxInChunk);
        this.maxSpawnInChunk = config.get("MOB CONTROLS." + this.mobName, "Max Pack Size", this.maxSpawnInChunk).getInt(this.maxSpawnInChunk);
        this.spawnType = ConfigHelper.configGetCreatureType(config, "MOB CONTROLS." + this.mobName, "Spawn List Type", this.spawnType);
        this.useGlobalSpawn = config.get("MOB CONTROLS." + this.mobName, "Use Global Spawn Rates", this.useGlobalSpawn).getBoolean(this.useGlobalSpawn);
    }

    @Override
    public void loadBiomesFromConfig(Configuration config) {
        HashSet<String> defaultBiomesToSpawn = this.getDefaultBiomesToSpawn();
        for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
            if (BiomeGenBase.func_150565_n()[i] == null) continue;
            boolean defaultShouldSpawn = defaultBiomesToSpawn.contains(BiomeGenBase.func_150565_n()[i].field_76791_y);
            SpawnEntry spawnEntry = ConfigHelper.configGetSpawnEntry(config, "Mob Spawn Biome Controls." + this.mobName, BiomeGenBase.func_150565_n()[i], defaultShouldSpawn, this.spawnRate, this.minInChunk, this.maxInChunk);
            if (spawnEntry == null) continue;
            this.biomesToSpawn.add(spawnEntry);
        }
    }

    public abstract HashSet<String> getDefaultBiomesToSpawn();

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        super.outputDataToList(config, customMobData);
        customMobData.secondarySpawnRate = this.secondarySpawnRate;
        customMobData.spawnType = this.spawnType;
    }

    @Override
    public void addSpawn() {
        if (this.spawnType == null) {
            return;
        }
        for (int i = 0; i < this.biomesToSpawn.size(); ++i) {
            if (this.useGlobalSpawn) {
                if (this.spawnRate > 0) {
                    EntityRegistry.addSpawn((Class)this.mobClass, (int)this.spawnRate, (int)this.minInChunk, (int)this.maxInChunk, (EnumCreatureType)this.spawnType, (BiomeGenBase[])new BiomeGenBase[]{this.biomesToSpawn.get((int)i).biome});
                }
            } else if (this.biomesToSpawn.get((int)i).spawnRate > 0) {
                EntityRegistry.addSpawn((Class)this.mobClass, (int)this.biomesToSpawn.get((int)i).spawnRate, (int)this.biomesToSpawn.get((int)i).minInChunk, (int)this.biomesToSpawn.get((int)i).maxInChunk, (EnumCreatureType)this.spawnType, (BiomeGenBase[])new BiomeGenBase[]{this.biomesToSpawn.get((int)i).biome});
            }
            if (!this.reportSpawningInLog) continue;
            ProjectZuluLog.info("Registering %s to biome %s at rates of %s,%s,%s", this.mobClass.getSimpleName(), this.biomesToSpawn.get((int)i).biome.field_76791_y, this.biomesToSpawn.get((int)i).spawnRate, this.biomesToSpawn.get((int)i).minInChunk, this.biomesToSpawn.get((int)i).maxInChunk);
        }
    }

    protected HashSet<String> typeToArray(BiomeDictionary.Type type) {
        BiomeGenBase[] biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type);
        HashSet<String> names = new HashSet<String>(15);
        for (BiomeGenBase biome : biomes) {
            names.add(biome.field_76791_y);
        }
        return names;
    }
}

