/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core.itemblockdeclaration;

import com.stek101.projectzulu.common.core.itemblockdeclaration.ItemBlockDeclaration;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class BlockDeclaration
implements ItemBlockDeclaration {
    private int registerPass;
    public final String name;
    private boolean isEnabled = true;
    private boolean isCreated = false;

    public BlockDeclaration(String name) {
        this(name, 0);
    }

    public BlockDeclaration(String name, int registerPass) {
        this.name = name;
        this.registerPass = registerPass;
    }

    @Override
    public ItemBlockDeclaration.Type getType() {
        return ItemBlockDeclaration.Type.Block;
    }

    @Override
    public int getRegisterPass() {
        return this.registerPass;
    }

    @Override
    public final void createWithConfig(Configuration config, boolean readOnly) {
        if (!readOnly) {
            Property property = config.get("block", this.name + " isEnabled", this.isEnabled);
            this.isEnabled = property.getBoolean(this.isEnabled);
            if (this.isEnabled) {
                this.preCreateLoadConfig(config);
                this.isCreated = this.createBlock();
                this.postCreateLoadConfig(config);
            }
        }
    }

    protected void preCreateLoadConfig(Configuration config) {
    }

    protected void postCreateLoadConfig(Configuration config) {
    }

    protected abstract boolean createBlock();

    @Override
    public final void register(Side side) {
        if (this.isCreated) {
            this.registerBlock();
            if (!side.isServer()) {
                this.clientRegisterBlock();
            }
        }
    }

    protected abstract void registerBlock();

    @SideOnly(value=Side.CLIENT)
    protected void clientRegisterBlock() {
    }
}

