/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.core.terrain;

import com.stek101.projectzulu.common.core.terrain.TerrainFeature;
import cpw.mods.fml.common.IWorldGenerator;
import java.io.File;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class FeatureGenerator
implements IWorldGenerator {
    private ConcurrentHashMap<String, TerrainFeature> structures = new ConcurrentHashMap();

    public void registerStructure(TerrainFeature ... feature) {
        for (TerrainFeature terrainFeature : feature) {
            this.structures.put(terrainFeature.getFeatureName().toLowerCase(), terrainFeature);
        }
    }

    public TerrainFeature getRegisteredStructure(String featureName) {
        return this.structures.get(featureName.toLowerCase());
    }

    public void initialize(File modConfigDirectory) {
        for (TerrainFeature terrainFeature : this.structures.values()) {
            terrainFeature.initialize(modConfigDirectory);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (TerrainFeature.Size featureSize : TerrainFeature.Size.values()) {
            for (TerrainFeature terrainFeature : this.structures.values()) {
                if (terrainFeature.getFeatureSize() != featureSize) continue;
                ChunkCoordinates[] coords = terrainFeature.getGenerationCoordinates(world, chunkX, chunkZ);
                boolean generated = false;
                for (ChunkCoordinates genWorldCoords : coords) {
                    if (!terrainFeature.canGenerateHere(world, chunkX, chunkZ, genWorldCoords, random)) continue;
                    terrainFeature.generateFeature(world, chunkX, chunkZ, genWorldCoords, random, TerrainFeature.FeatureDirection.CENTERED);
                    generated = true;
                }
                if (!generated) continue;
                return;
            }
        }
    }
}

