/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.CreatureFields;
import com.stek101.projectzulu.common.dungeon.GuiScrollingList;
import com.stek101.projectzulu.common.dungeon.NBTHelper;
import com.stek101.projectzulu.common.dungeon.NBTNode;
import com.stek101.projectzulu.common.dungeon.NBTTree;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Point;

public class GUINBTList
extends GuiScrollingList {
    NBTTree nodeTree;
    ArrayList<NBTNode> nodeList;
    CreatureFields parent;
    int selectedElement = -1;
    Point screenSize;
    Point backgroundSize;

    public GUINBTList(CreatureFields parent, Minecraft mc, NBTTree nodeTree, int listWidth, Point screenSize, Point backgroundSize) {
        super(mc, listWidth, backgroundSize.getY() + 50, (screenSize.getY() - backgroundSize.getY()) / 2 + 100 - 14, (screenSize.getY() - backgroundSize.getY()) / 2 + backgroundSize.getY() - 60 - 12, (screenSize.getX() - backgroundSize.getX()) / 2 + 6, mc.field_71466_p.field_78288_b + 8);
        this.parent = parent;
        this.nodeTree = nodeTree;
        this.nodeList = nodeTree.toArrayList();
        this.screenSize = screenSize;
        this.backgroundSize = backgroundSize;
    }

    public void recreateNodeList() {
        this.nodeList = this.nodeTree.toArrayList();
        this.selectedElement = -1;
    }

    @Override
    protected int getSize() {
        return this.nodeList.size();
    }

    @Override
    protected void elementClicked(int clickedIndex, boolean var2) {
        ProjectZuluLog.info("Clicked on Tag of Type %s with name %s", this.nodeList.get(clickedIndex).getData().toString(), this.nodeList.get(clickedIndex).getTagName());
        this.parent.setSelectedCurentNode(this.nodeList.get(clickedIndex));
        this.selectedElement = clickedIndex;
    }

    @Override
    protected boolean isSelected(int selectedIndex) {
        return selectedIndex == this.selectedElement;
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected int getContentHeight() {
        return this.getSize() * this.slotHeight;
    }

    @Override
    protected void drawSlot(int listIndex, int var2, int var3, int var4, Tessellator tessellator) {
        int numParents = this.nodeList.get(listIndex).countParents();
        String filler = "";
        for (int i = 0; i < numParents; ++i) {
            filler = filler.concat("   ");
        }
        String renderString = filler + this.nodeList.get(listIndex).getTagName();
        String renderResult = "";
        int countChildren = this.nodeList.get(listIndex).getChildren().size();
        int parentCount = this.nodeList.get(listIndex).countParents();
        if (countChildren == 0) {
            renderResult = NBTHelper.getByID(this.nodeList.get(listIndex).getData().func_74732_a()).getValue(this.nodeList.get(listIndex).getData());
        }
        int maxResultLength = 13 - parentCount * 2;
        this.parent.mc.field_71466_p.func_78261_a(renderString, this.left + 3, var3 + 2, 0xFFFFFF);
        this.parent.mc.field_71466_p.func_78261_a(renderResult.length() > maxResultLength ? renderResult.substring(0, maxResultLength) : renderResult, this.left + 140, var3 + 2, 0xFFFFFF);
    }

    public void drawScreen(Point screenSize, Point backgroundSize, int mouseX, int mouseY, float p_22243_3_) {
        super.drawScreen(mouseX, mouseY, p_22243_3_);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2929);
        this.drawScrollOverlay(this.left, (screenSize.getY() - backgroundSize.getY()) / 2 + 55, this.top, 255, 255);
        this.drawScrollOverlay(this.left, this.bottom, (screenSize.getY() - backgroundSize.getY()) / 2 + backgroundSize.getY() - 4, 255, 255);
    }

    private void drawScrollOverlay(int leftOffset, int topHeight, int botHeight, int alphaBottom, int alphaTop) {
        Tessellator var5 = Tessellator.field_78398_a;
        GL11.glBindTexture((int)3553, (int)this.parent.mc.field_71446_o.func_110581_b(this.getBackgroundTexture()).func_110552_b());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float imageSize = 32.0f;
        var5.func_78382_b();
        var5.func_78374_a((double)leftOffset, (double)botHeight, 0.0, 0.0, (double)((float)botHeight / imageSize));
        var5.func_78374_a((double)leftOffset + (double)this.listWidth, (double)botHeight, 0.0, (double)((float)this.listWidth / imageSize), (double)((float)botHeight / imageSize));
        var5.func_78374_a((double)leftOffset + (double)this.listWidth, (double)topHeight, 0.0, (double)((float)this.listWidth / imageSize), (double)((float)topHeight / imageSize));
        var5.func_78374_a((double)leftOffset, (double)topHeight, 0.0, 0.0, (double)((float)topHeight / imageSize));
        var5.func_78381_a();
    }
}

