/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon;

import com.stek101.projectzulu.common.core.ObfuscationHelper;
import com.stek101.projectzulu.common.dungeon.ButtonIDs;
import com.stek101.projectzulu.common.dungeon.CreatureFields;
import com.stek101.projectzulu.common.dungeon.DataFields;
import com.stek101.projectzulu.common.dungeon.GUISelectionList;
import com.stek101.projectzulu.common.dungeon.ListType;
import com.stek101.projectzulu.common.dungeon.Node;
import com.stek101.projectzulu.common.dungeon.SpawnerFields;
import com.stek101.projectzulu.common.dungeon.TileEntityLimitedMobSpawnData;
import com.stek101.projectzulu.common.dungeon.TileEntityLimitedMobSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Point;

public class GuiLimitedMobSpawner
extends GuiScreen {
    public TileEntityLimitedMobSpawner limitedMobSpawner;
    Point backgroundSize = new Point(256, 244);
    int numberOfFields = 1;
    int currentDataField = 0;
    private List<DataFields> dataFields = new ArrayList<DataFields>();
    public static final ResourceLocation SPAWNER_GUI = new ResourceLocation("projectzuludungeon", "textures/mobspawnergui.png");
    GUISelectionList scrollingList;
    public ListType currentListType = ListType.NONE;
    Node rootCreatureNode = new Node(null, "root");
    Node rootSoundNode = new Node(null, "root");

    public DataFields getDataField(int index) {
        return this.dataFields.get(index);
    }

    public GuiLimitedMobSpawner(TileEntityLimitedMobSpawner limitedMobSpawner) {
        this.limitedMobSpawner = limitedMobSpawner;
        this.numberOfFields = limitedMobSpawner.getSpawnList() != null ? limitedMobSpawner.getSpawnList().size() + 1 : 1;
    }

    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new GuiButton(ButtonIDs.BACKWARDS.index, this.field_146294_l / 2 - 12 - 38, (this.field_146295_m + this.backgroundSize.getY()) / 2 - 47, 25, 20, "<<"));
        this.field_146292_n.add(new GuiButton(ButtonIDs.FORWARD.index, this.field_146294_l / 2 - 12 + 8, (this.field_146295_m + this.backgroundSize.getY()) / 2 - 47, 25, 20, ">>"));
        this.field_146292_n.add(new GuiButton(ButtonIDs.SAVENCLOSE.index, this.field_146294_l / 2 - 35 - 88, (this.field_146295_m + this.backgroundSize.getY()) / 2 - 47, 70, 20, "Save & Quit"));
        this.field_146292_n.add(new GuiButton(ButtonIDs.CANCEL.index, this.field_146294_l / 2 - 35 - 88, (this.field_146295_m + this.backgroundSize.getY()) / 2 - 25, 70, 20, "Cancel"));
        this.field_146292_n.add(new GuiButton(ButtonIDs.NEWENTRY.index, this.field_146294_l / 2 - 35 + 75 - 17, (this.field_146295_m + this.backgroundSize.getY()) / 2 - 47, 70, 20, "New Entry"));
        this.field_146292_n.add(new GuiButton(ButtonIDs.DELENTRY.index, this.field_146294_l / 2 - 35 + 75 - 17, (this.field_146295_m + this.backgroundSize.getY()) / 2 - 25, 70, 20, "Delete Entry"));
        this.limitedMobSpawner.setEditable(false);
        for (int i = 0; i < this.numberOfFields; ++i) {
            if (this.dataFields.isEmpty() || this.dataFields.size() <= i) {
                if (i == 0) {
                    this.dataFields.add(0, new SpawnerFields(this).createFields(this.field_146297_k, this.field_146294_l, this.field_146295_m, this.backgroundSize));
                    this.dataFields.get(0).loadFromTileEntity(this.limitedMobSpawner, i);
                    continue;
                }
                this.dataFields.add(i, new CreatureFields(this.field_146297_k).createFields(this.field_146297_k, this.field_146294_l, this.field_146295_m, this.backgroundSize));
                this.dataFields.get(i).loadFromTileEntity(this.limitedMobSpawner, i);
                continue;
            }
            this.dataFields.get(i).createFields(this.field_146297_k, this.field_146294_l, this.field_146295_m, this.backgroundSize);
        }
        switch (this.currentListType) {
            case Creature: {
                this.scrollingList = new GUISelectionList(this, this.rootCreatureNode, this.currentListType, 85, new Point(this.field_146294_l, this.field_146295_m), this.backgroundSize);
                this.scrollingList.registerScrollButtons(this.field_146292_n, 7, 8);
                break;
            }
            case Sound: {
                this.scrollingList = new GUISelectionList(this, this.rootSoundNode, this.currentListType, 85, new Point(this.field_146294_l, this.field_146295_m), this.backgroundSize);
                this.scrollingList.registerScrollButtons(this.field_146292_n, 7, 8);
                break;
            }
        }
    }

    public void openList(ListType listType) {
        this.currentListType = listType;
        switch (this.currentListType) {
            case Creature: {
                if (this.rootCreatureNode.numberOfChildren() == 0) {
                    for (String stringKey : EntityList.field_75625_b.keySet()) {
                        if (!EntityLiving.class.isAssignableFrom((Class)EntityList.field_75625_b.get(stringKey)) || stringKey.equals("Mob")) continue;
                        this.rootCreatureNode.addChild("root." + stringKey);
                    }
                    this.rootCreatureNode.sortNodeTree();
                }
                this.scrollingList = new GUISelectionList(this, this.rootCreatureNode, this.currentListType, 85, new Point(this.field_146294_l, this.field_146295_m), this.backgroundSize);
                this.scrollingList.registerScrollButtons(this.field_146292_n, 7, 8);
                break;
            }
            case Sound: {
                SoundRegistry registry;
                HashMap soundHash;
                if (this.rootSoundNode.numberOfChildren() == 0 && (soundHash = ObfuscationHelper.getFieldFromReflection("field_148764_a", "field_148764_a", (Object)(registry = ObfuscationHelper.getFieldFromReflection("field_147697_e", "sndRegistry", (Object)this.field_146297_k.func_147118_V(), SoundRegistry.class)), HashMap.class)) != null) {
                    for (ResourceLocation key : soundHash.keySet()) {
                        this.rootSoundNode.addChild("root." + key.func_110624_b() + "." + key.func_110623_a());
                    }
                    this.rootSoundNode.sortNodeTree();
                }
                this.scrollingList = new GUISelectionList(this, this.rootSoundNode, this.currentListType, 85, new Point(this.field_146294_l, this.field_146295_m), this.backgroundSize);
                this.scrollingList.registerScrollButtons(this.field_146292_n, 7, 8);
                break;
            }
            default: {
                throw new IllegalStateException("Trying to Open invalid List type " + listType.toString());
            }
        }
    }

    public void closeList() {
        this.currentListType = ListType.NONE;
        this.scrollingList = null;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        this.limitedMobSpawner.setEditable(true);
    }

    public void func_73876_c() {
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (ButtonIDs.getButtonByIndex(button.field_146127_k)) {
                case CANCEL: {
                    this.limitedMobSpawner.func_70296_d();
                    this.closeGui();
                    break;
                }
                case FORWARD: {
                    if (this.currentDataField + 1 >= this.dataFields.size()) break;
                    ++this.currentDataField;
                    break;
                }
                case BACKWARDS: {
                    if (this.currentDataField <= 0) break;
                    --this.currentDataField;
                    break;
                }
                case SAVENCLOSE: {
                    this.limitedMobSpawner.func_70296_d();
                    this.saveGuiToTileEntity();
                    this.closeGui();
                    break;
                }
                case DELENTRY: {
                    if (this.currentDataField == 0) break;
                    this.dataFields.remove(this.currentDataField);
                    --this.currentDataField;
                    --this.numberOfFields;
                    break;
                }
                case NEWENTRY: {
                    this.dataFields.add(new CreatureFields(this.field_146297_k).createFields(this.field_146297_k, this.field_146294_l, this.field_146295_m, this.backgroundSize));
                    this.dataFields.get(this.dataFields.size() - 1).loadFromTileEntity(this.limitedMobSpawner, this.dataFields.size() - 1);
                    this.currentDataField = this.dataFields.size() - 1;
                    ++this.numberOfFields;
                    break;
                }
                default: {
                    throw new IllegalStateException("Button action does not exist.");
                }
            }
        }
    }

    public void closeGui() {
        this.field_146297_k.func_147108_a((GuiScreen)null);
    }

    public void loadGuiFromTileEntity() {
        for (int i = 0; i < this.dataFields.size(); ++i) {
            this.dataFields.get(i).loadFromTileEntity(this.limitedMobSpawner, i);
        }
    }

    public void saveGuiToTileEntity() {
        if (this.limitedMobSpawner.getSpawnList() == null) {
            this.limitedMobSpawner.setSpawnList(new ArrayList<TileEntityLimitedMobSpawnData>());
        }
        this.limitedMobSpawner.getSpawnList().clear();
        for (int i = 0; i < this.dataFields.size(); ++i) {
            this.dataFields.get(i).saveToTileEntity(this.limitedMobSpawner);
        }
        if (this.limitedMobSpawner.getSpawnList().isEmpty()) {
            this.limitedMobSpawner.setSpawnList(null);
        }
        this.limitedMobSpawner.syncToServer();
    }

    protected void func_73869_a(char keyChar, int keyID) {
        super.func_73869_a(keyChar, keyID);
        if (this.dataFields.get(this.currentDataField).isEnabled()) {
            this.dataFields.get(this.currentDataField).keyboardInput(keyChar, keyID);
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        if (this.dataFields.get(this.currentDataField).isEnabled()) {
            this.dataFields.get(this.currentDataField).mouseClicked(this, this.field_146297_k, par1, par2, par3);
        }
        if (this.currentListType != ListType.NONE) {
            this.scrollingList.mouseClicked(par1, par2, par3);
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        if (this.dataFields.get(this.currentDataField).isEnabled()) {
            this.dataFields.get(this.currentDataField).render(this.field_146297_k, par1, par2, par3, new Point(this.field_146294_l, this.field_146295_m), this.backgroundSize);
        }
        String titleString = "Edit Mob Spawner Settings " + Integer.toString(this.currentDataField) + "/" + Integer.toString(this.dataFields.size() - 1);
        this.field_146289_q.func_78276_b(titleString, (this.field_146294_l - this.field_146289_q.func_78256_a(titleString)) / 2, (this.field_146295_m - this.backgroundSize.getY()) / 2 + 8, 0x404040);
        super.func_73863_a(par1, par2, par3);
        if (this.currentListType != ListType.NONE) {
            this.scrollingList.drawBackground();
            this.scrollingList.drawScreen(new Point(this.field_146294_l, this.field_146295_m), this.backgroundSize, par1, par2, par3);
        }
    }

    public void func_146276_q_() {
        super.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(SPAWNER_GUI);
        int xCoord = (this.field_146294_l - this.backgroundSize.getX()) / 2;
        int yCoord = (this.field_146295_m - this.backgroundSize.getY()) / 2;
        this.func_73729_b(xCoord, yCoord, 0, 0, this.backgroundSize.getX(), this.backgroundSize.getY());
    }
}

