/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon;

import com.google.common.base.Optional;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NBTNode {
    private NBTBase data;
    private NBTNode parent;
    private Optional<String> tagName;
    private List<NBTNode> children;

    public NBTNode(NBTBase data, NBTNode parent, String tagName) {
        this.data = data;
        this.parent = parent;
        this.children = NBTHelper.getByID(data.func_74732_a()).getChildTags(data, this);
        this.tagName = tagName != null ? Optional.of((Object)tagName) : Optional.absent();
    }

    public String getTagName() {
        return this.tagName.isPresent() ? (String)this.tagName.get() : "";
    }

    public NBTBase getData() {
        return this.data;
    }

    public String getValue() {
        return NBTHelper.getByID(this.data.func_74732_a()).getValue(this.data);
    }

    public NBTBase createNBTFromString(String newValue) {
        NBTBase nbtBase = null;
        try {
            nbtBase = NBTHelper.getByID(this.data.func_74732_a()).getNBTFromString(this.data, newValue);
        }
        catch (NumberFormatException e) {
            ProjectZuluLog.warning("Rejecting NBTTag Value %s due to incorrect formatting", newValue);
        }
        return nbtBase;
    }

    public NBTNode getParent() {
        return this.parent;
    }

    public boolean replaceChild(NBTNode childNode, NBTNode newChild) {
        int index = this.children.indexOf(childNode);
        if (index > -1) {
            this.children.set(index, newChild);
            return true;
        }
        ProjectZuluLog.warning("Could not find Child %s with Parent %s ", childNode.getTagName(), this.getData());
        return false;
    }

    public List<NBTNode> getChildren() {
        return this.children;
    }

    public int countParents() {
        int numParents = 0;
        if (this.parent != null) {
            ++numParents;
            numParents += this.parent.countParents();
        }
        return numParents;
    }

    public boolean addChild(NBTBase data, String tagName) {
        return this.children.add(new NBTNode(data, this, tagName));
    }

    public boolean removeChild(NBTNode nodeToRemove) {
        return this.children.remove(nodeToRemove);
    }

    public void writeNodeandChildrenToNBT(NBTTagCompound nbtTagCompound) {
        NBTHelper helper = NBTHelper.getByID(this.data.func_74732_a());
        helper.writeToNBT(nbtTagCompound, this);
    }

    public void writeNodeandChildrenToArrayList(ArrayList<NBTNode> nodeList) {
        nodeList.add(this);
        for (NBTNode child : this.getChildren()) {
            child.writeNodeandChildrenToArrayList(nodeList);
        }
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        if (this.getClass() != otherObj.getClass()) {
            return false;
        }
        NBTNode otherNode = (NBTNode)otherObj;
        if (this.children == null ? otherNode.children != null : !this.children.equals(otherNode.children)) {
            return false;
        }
        if (this.data == null ? otherNode.data != null : !this.data.equals((Object)otherNode.data)) {
            return false;
        }
        return !(this.parent == null ? otherNode.parent != null : !this.parent.equals(otherNode.parent));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }
}

