/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Node
implements Comparable<Node> {
    private Node parent;
    private String name;
    private List<Node> children = new ArrayList<Node>();

    public Node(Node parent, String data) {
        this.parent = parent;
        this.parseDataForNode(data);
        this.parseDataForChild(data);
    }

    public Node getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.prefixParents(this.name);
    }

    private String prefixParents(String name) {
        if (this.parent != null && this.parent.parent != null && this.parent.parent.name.equals("root")) {
            return this.parent.prefixParents(this.parent.name + ":" + name);
        }
        if (this.parent != null && !this.parent.name.equals("root")) {
            return this.parent.prefixParents(this.parent.name + "." + name);
        }
        return name;
    }

    public boolean addChild(String data) {
        this.parseDataForChild(data);
        return true;
    }

    public Node getChild(int index) {
        return this.children.get(index);
    }

    public int numberOfChildren() {
        return this.children.size();
    }

    public void sortNodeTree() {
        Collections.sort(this.children);
        for (Node child : this.children) {
            child.sortNodeTree();
        }
    }

    private boolean parseDataForNode(String data) {
        String[] stringSplitData = data.split("\\.", 2);
        this.name = stringSplitData[0];
        return true;
    }

    private boolean parseDataForChild(String data) {
        String[] stringSplitData = data.split("\\.", 2);
        if (stringSplitData.length < 2) {
            return false;
        }
        String[] stringSplitChild = stringSplitData[1].split("\\.", 2);
        String childName = stringSplitChild[0];
        for (Node child : this.children) {
            if (!child.name.equals(childName)) continue;
            child.addChild(stringSplitData[1]);
            return true;
        }
        this.children.add(new Node(this, stringSplitData[1]));
        return true;
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        if (this.getClass() != otherObj.getClass()) {
            return false;
        }
        Node otherNode = (Node)otherObj;
        if (this.children == null ? otherNode.children != null : !this.children.equals(otherNode.children)) {
            return false;
        }
        if (this.name == null ? otherNode.name != null : !this.name.equals(otherNode.name)) {
            return false;
        }
        return !(this.parent == null ? otherNode.parent != null : !this.parent.equals(otherNode.parent));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    @Override
    public int compareTo(Node node) {
        if (node != null && node.children.size() > 0) {
            if (this.children.size() > 0) {
                return this.name.compareTo(node.name);
            }
            return 1;
        }
        if (this.children.size() > 0) {
            return -1;
        }
        return this.name.compareTo(node.name);
    }
}

