/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.commands;

import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class CommandSpawnEntity
extends CommandBase {
    public String func_71517_b() {
        return "spawnentity";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "commands.spawnentity.usage";
    }

    public void func_71515_b(ICommandSender commandSender, String[] stringArgs) {
        if (stringArgs.length < 2) {
            throw new WrongUsageException("commands.spawnentity.usage", new Object[0]);
        }
        double spawnTargetX = 0.0;
        double spawnTargetY = 0.0;
        double spawnTargetZ = 0.0;
        float rotYaw = 0.0f;
        float rotPitch = 0.0f;
        EntityPlayerMP targetPlayer = CommandSpawnEntity.func_82359_c((ICommandSender)commandSender, (String)stringArgs[0]);
        if (targetPlayer == null) {
            throw new PlayerNotFoundException();
        }
        Entity spawnableEntity = EntityList.func_75620_a((String)stringArgs[1], (World)targetPlayer.field_70170_p);
        if (spawnableEntity == null) {
            throw new WrongUsageException("commands.spawnentity.noentity", new Object[0]);
        }
        if (stringArgs.length == 2) {
            spawnTargetX = (int)targetPlayer.field_70165_t;
            spawnTargetY = (int)targetPlayer.field_70163_u;
            spawnTargetZ = (int)targetPlayer.field_70161_v;
        } else if (stringArgs.length == 5 || stringArgs.length == 7) {
            int indexOfPos = stringArgs.length - 3;
            spawnTargetX = (int)this.parsePosition(commandSender, targetPlayer.field_70165_t, stringArgs[indexOfPos++]);
            spawnTargetY = (int)this.parsePositionWithBounds(commandSender, targetPlayer.field_70163_u, stringArgs[indexOfPos++], 0, 0);
            spawnTargetZ = (int)this.parsePosition(commandSender, targetPlayer.field_70161_v, stringArgs[indexOfPos++]);
        }
        if (stringArgs.length == 7) {
            rotYaw = CommandSpawnEntity.func_71532_a((ICommandSender)commandSender, (String)stringArgs[2], (int)0, (int)360);
            rotPitch = CommandSpawnEntity.func_71532_a((ICommandSender)commandSender, (String)stringArgs[3], (int)0, (int)360);
        }
        spawnableEntity.func_70012_b(spawnTargetX, spawnTargetY, spawnTargetZ, rotYaw, rotPitch);
        targetPlayer.field_70170_p.func_72838_d(spawnableEntity);
    }

    public List func_71516_a(ICommandSender par1ICommandSender, String[] par2ArrayOfStr) {
        return par2ArrayOfStr.length != 1 && par2ArrayOfStr.length != 2 ? null : CommandSpawnEntity.func_71530_a((String[])par2ArrayOfStr, (String[])MinecraftServer.func_71276_C().func_71213_z());
    }

    private double parsePosition(ICommandSender commandSender, double currentPos, String stringDouble) {
        return this.parsePositionWithBounds(commandSender, currentPos, stringDouble, -30000000, 30000000);
    }

    private double parsePositionWithBounds(ICommandSender commandSender, double currentPos, String stringDouble, int lowerLimit, int upperLimit) {
        double targetPos;
        boolean isRelativeCoords = stringDouble.startsWith("~");
        double d = targetPos = isRelativeCoords ? currentPos : 0.0;
        if (!isRelativeCoords || stringDouble.length() > 1) {
            boolean hasDecimal = stringDouble.contains(".");
            if (isRelativeCoords) {
                stringDouble = stringDouble.substring(1);
            }
            targetPos += CommandSpawnEntity.func_82363_b((ICommandSender)commandSender, (String)stringDouble);
            if (!hasDecimal && !isRelativeCoords) {
                targetPos += 0.5;
            }
        }
        if (lowerLimit != 0 || upperLimit != 0) {
            if (targetPos < (double)lowerLimit) {
                throw new NumberInvalidException("commands.generic.double.tooSmall", new Object[]{targetPos, lowerLimit});
            }
            if (targetPos > (double)upperLimit) {
                throw new NumberInvalidException("commands.generic.double.tooBig", new Object[]{targetPos, upperLimit});
            }
        }
        return targetPos;
    }
}

