/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag.keys;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.spawner.tag.ParsingHelper;
import com.stek101.projectzulu.common.dungeon.spawner.tag.TypeValuePair;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.Key;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParser;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBase;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettings;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;

public class KeyParserEntities
extends KeyParserBase {
    public KeyParserEntities(Key key) {
        super(key, true, KeyParser.KeyType.CHAINABLE);
    }

    @Override
    public boolean parseChainable(String parseable, ArrayList<TypeValuePair> parsedChainable, ArrayList<OptionalSettings.Operand> operandvalue) {
        String[] pieces = parseable.split(",");
        OptionalSettings.Operand operand = this.parseOperand(pieces);
        if (pieces.length == 6) {
            String entityName = pieces[1];
            int minSearchRange = ParsingHelper.parseFilteredInteger(pieces[2], 32, "1st " + this.key.key);
            int maxSearchRange = ParsingHelper.parseFilteredInteger(pieces[3], 32, "1st " + this.key.key);
            int min = ParsingHelper.parseFilteredInteger(pieces[4], 16, "2st " + this.key.key);
            int max = ParsingHelper.parseFilteredInteger(pieces[5], -1, "3nd " + this.key.key);
            TypeValuePair typeValue = new TypeValuePair(this.key, new Object[]{this.isInverted(pieces[0]), entityName, minSearchRange, maxSearchRange, min, max});
            parsedChainable.add(typeValue);
            operandvalue.add(operand);
            return true;
        }
        ProjectZuluLog.severe("Error Parsing %s Parameter. Invalid Argument Length.", this.key.key);
        return false;
    }

    @Override
    public boolean parseValue(String parseable, HashMap<String, Object> valueCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValidLocation(World world, EntityLiving entity, int xCoord, int yCoord, int zCoord, TypeValuePair typeValuePair, HashMap<String, Object> valueCache) {
        boolean isValid;
        int maxRange;
        Object[] values = (Object[])typeValuePair.getValue();
        boolean isInverted = (Boolean)values[0];
        String entityName = (String)values[1];
        int minSearch = (Integer)values[2];
        int maxSearch = (Integer)values[3];
        int current = this.countNearbyEntities(world, entityName, xCoord, yCoord, zCoord, minSearch, maxSearch);
        int minRange = (Integer)values[4];
        if (minRange <= (maxRange = ((Integer)values[5]).intValue())) {
            isValid = current <= maxRange && current >= minRange;
        } else {
            boolean bl = isValid = current >= minRange || current <= maxRange;
        }
        return isInverted ? isValid : !isValid;
    }

    private int countNearbyEntities(World world, String searchName, int xCoord, int yCoord, int zCoord, int minRange, int maxRange) {
        int count = 0;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entities = (Entity)world.field_72996_f.get(i);
            if (!entities.func_70089_S()) continue;
            String entityName = "";
            try {
                entityName = EntityList.func_75621_b((Entity)entities);
            }
            catch (Exception e) {
                ProjectZuluLog.severe("Error Accessing Entity Name of %s", entities.getClass().getSimpleName());
                e.printStackTrace();
                continue;
            }
            if (!searchName.trim().equals("") && !searchName.equalsIgnoreCase(entityName)) continue;
            int distance = (int)Math.sqrt(entities.func_70092_e((double)xCoord, (double)yCoord, (double)zCoord));
            if (maxRange >= minRange && distance >= minRange && distance <= maxRange) {
                ++count;
                continue;
            }
            if (maxRange >= minRange || distance < minRange && distance > maxRange) continue;
            ++count;
        }
        return count;
    }
}

