/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.dungeon.spawner.tag.keys;

import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.dungeon.spawner.tag.ParsingHelper;
import com.stek101.projectzulu.common.dungeon.spawner.tag.TypeValuePair;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.Key;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParser;
import com.stek101.projectzulu.common.dungeon.spawner.tag.keys.KeyParserBase;
import com.stek101.projectzulu.common.dungeon.spawner.tag.settings.OptionalSettings;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class KeyParserPlayers
extends KeyParserBase {
    public KeyParserPlayers(Key key) {
        super(key, true, KeyParser.KeyType.CHAINABLE);
    }

    @Override
    public boolean parseChainable(String parseable, ArrayList<TypeValuePair> parsedChainable, ArrayList<OptionalSettings.Operand> operandvalue) {
        String[] pieces = parseable.split(",");
        OptionalSettings.Operand operand = this.parseOperand(pieces);
        if (pieces.length == 5) {
            int minSearchRange = ParsingHelper.parseFilteredInteger(pieces[1], 32, "1st " + this.key.key);
            int maxSearchRange = ParsingHelper.parseFilteredInteger(pieces[2], 32, "1st " + this.key.key);
            int min = ParsingHelper.parseFilteredInteger(pieces[3], 16, "2st " + this.key.key);
            int max = ParsingHelper.parseFilteredInteger(pieces[4], -1, "3nd " + this.key.key);
            TypeValuePair typeValue = new TypeValuePair(this.key, new Object[]{this.isInverted(pieces[0]), minSearchRange, maxSearchRange, min, max});
            parsedChainable.add(typeValue);
            operandvalue.add(operand);
            return true;
        }
        ProjectZuluLog.severe("Error Parsing %s Parameter. Invalid Argument Length.", this.key.key);
        return false;
    }

    @Override
    public boolean parseValue(String parseable, HashMap<String, Object> valueCache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValidLocation(World world, EntityLiving entity, int xCoord, int yCoord, int zCoord, TypeValuePair typeValuePair, HashMap<String, Object> valueCache) {
        boolean isValid;
        int maxRange;
        Object[] values = (Object[])typeValuePair.getValue();
        boolean isInverted = (Boolean)values[0];
        int minSearch = (Integer)values[1];
        int maxSearch = (Integer)values[2];
        int current = this.countNearbyPlayers(world, xCoord, yCoord, zCoord, minSearch, maxSearch);
        int minRange = (Integer)values[3];
        if (minRange <= (maxRange = ((Integer)values[4]).intValue())) {
            isValid = current <= maxRange && current >= minRange;
        } else {
            boolean bl = isValid = current >= minRange || current <= maxRange;
        }
        return isInverted ? isValid : !isValid;
    }

    private int countNearbyPlayers(World world, int xCoord, int yCoord, int zCoord, int minRange, int maxRange) {
        int count = 0;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            if (!player.func_70089_S()) continue;
            int distance = (int)Math.sqrt(player.func_70092_e((double)xCoord, (double)yCoord, (double)zCoord));
            if (maxRange >= minRange && distance >= minRange && distance <= maxRange) {
                ++count;
                continue;
            }
            if (maxRange >= minRange || distance < minRange && distance > maxRange) continue;
            ++count;
        }
        return count;
    }
}

