/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entity;

import com.stek101.projectzulu.common.ProjectZulu_Core;
import com.stek101.projectzulu.common.Properties;
import com.stek101.projectzulu.common.api.CustomEntityList;
import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.mobs.entity.EntityGenericTameable;
import com.stek101.projectzulu.common.mobs.entity.EntityStates;
import com.stek101.projectzulu.common.mobs.packets.PZPacketAnimTime;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.Collection;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

public class EntityGenericAnimal
extends EntityGenericTameable {
    public int maxAnimTime = 20;
    public boolean forceDespawn = false;
    private float flightChance;

    public EntityGenericAnimal(World par1World) {
        super(par1World);
        this.field_70728_aV = 3;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        CustomEntityList entityEntry = CustomEntityList.getByName(EntityList.func_75621_b((Entity)this));
        if (entityEntry != null && ((CustomMobData)entityEntry.modData.get()).entityProperties != null) {
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)((CustomMobData)entityEntry.modData.get()).entityProperties.maxHealth);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)((CustomMobData)entityEntry.modData.get()).entityProperties.moveSpeed);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)((CustomMobData)entityEntry.modData.get()).entityProperties.followRange);
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a((double)((CustomMobData)entityEntry.modData.get()).entityProperties.knockbackResistance);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)((CustomMobData)entityEntry.modData.get()).entityProperties.attackDamage);
            this.flightChance = ((CustomMobData)entityEntry.modData.get()).entityProperties.flightChance;
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    protected void updateDWEntityState(EntityStates entityState) {
        this.field_70180_af.func_75692_b(20, (Object)((short)entityState.index));
    }

    public int getDWEntityState() {
        return this.field_70180_af.func_75693_b(20);
    }

    @Override
    protected void func_70619_bc() {
        this.updateAIState();
        super.func_70619_bc();
        if (this.shouldAttack) {
            this.setAngerLevel(3);
        }
        this.updateDWEntityState(this.entityState);
    }

    public void updateAIState() {
        if (this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && Properties.despawnInPeaceful && !this.isTamed()) {
            this.func_70106_y();
        }
        this.entityState = this.fleeingTick > 0 ? EntityStates.fleeing : (this.loveTimer > 0 ? EntityStates.inLove : (this.angerLevel > 0 && (this.func_70638_az() != null || this.func_70643_av() != null) ? EntityStates.attacking : (this.angerLevel > 0 ? EntityStates.looking : (this.isSitting() ? EntityStates.sitting : (this.shouldFollow ? EntityStates.following : EntityStates.idle)))));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.animTime = Math.max(this.animTime - 1, 0);
        this.entityState = EntityStates.getEntityByIndex(this.getDWEntityState());
    }

    @Override
    protected boolean func_70692_ba() {
        CustomEntityList entityEntry = CustomEntityList.getByName(EntityList.func_75621_b((Entity)this));
        if (entityEntry != null && !this.isTamed()) {
            return this.forceDespawn || ((CustomMobData)entityEntry.modData.get()).shouldDespawn;
        }
        return super.func_70692_ba();
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        CustomEntityList entityEntry = CustomEntityList.getByName(EntityList.func_75621_b((Entity)this));
        if (forSpawnCount && entityEntry != null) {
            return ((CustomMobData)entityEntry.modData.get()).spawnType != null ? ((CustomMobData)entityEntry.modData.get()).spawnType.equals((Object)type) : false;
        }
        if (entityEntry != null) {
            return ((CustomMobData)entityEntry.modData.get()).creatureType != null ? ((CustomMobData)entityEntry.modData.get()).creatureType.equals((Object)type) : super.isCreatureType(type, forSpawnCount);
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    public boolean func_70652_k(Entity targetEntity) {
        if (targetEntity.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && targetEntity.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            boolean attackedSucceded;
            this.animTime = this.maxAnimTime;
            if (!this.field_70170_p.field_72995_K) {
                PZPacketAnimTime message = new PZPacketAnimTime().setPacketData(this.func_145782_y(), this.animTime);
                ProjectZulu_Core.packetHandler.sendToAllAround(message, new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 30.0));
            }
            float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int knockbackScale = 0;
            if (targetEntity instanceof EntityLivingBase) {
                damage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)targetEntity));
                knockbackScale += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)targetEntity));
            }
            if (attackedSucceded = targetEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) {
                int fireScale;
                if (knockbackScale > 0) {
                    targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockbackScale * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockbackScale * 0.5f));
                    this.field_70159_w *= 0.6;
                    this.field_70179_y *= 0.6;
                }
                if ((fireScale = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                    targetEntity.func_70015_d(fireScale * 4);
                }
                if (targetEntity instanceof EntityLivingBase) {
                    EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)this);
                }
                EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)targetEntity);
            }
            return attackedSucceded && super.func_70652_k(targetEntity);
        }
        return false;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (super.func_70097_a(par1DamageSource, par2) && par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer attackingPlayer = (EntityPlayer)par1DamageSource.func_76346_g();
            if (this.shouldNotifySimilar(attackingPlayer)) {
                List var4 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(20.0, 20.0, 20.0));
                for (Entity nearbyEntity : var4) {
                    if (!nearbyEntity.getClass().equals(((Object)((Object)this)).getClass())) continue;
                    EntityGenericAnimal nearbyAlly = (EntityGenericAnimal)nearbyEntity;
                    nearbyAlly.entityAttackedReaction(attackingPlayer);
                }
            }
            this.entityAttackedReaction(attackingPlayer);
            return true;
        }
        return false;
    }

    protected void entityAttackedReaction(EntityPlayer attackingPlayer) {
        if (!this.isTamed()) {
            if (this.shouldPanic()) {
                this.setFleeTick(80);
            } else {
                this.setAngerLevel(400);
            }
        }
    }

    public boolean shouldNotifySimilar(EntityPlayer attackingPlayer) {
        return false;
    }

    protected boolean shouldPanic() {
        return !(this.field_70170_p.field_73012_v.nextFloat() * 100.0f >= this.flightChance);
    }

    protected int func_70693_a(EntityPlayer par1EntityPlayer) {
        if (this.isTamed()) {
            return 0;
        }
        if (this instanceof IMob || this.getEntityState() == EntityStates.attacking || this.getEntityState() == EntityStates.looking) {
            return 5;
        }
        return this.field_70146_Z.nextInt(2) + 1;
    }

    public boolean func_70601_bi() {
        int xCoord = MathHelper.func_76128_c((double)this.field_70165_t);
        int yCoord = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int zCoord = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean wasSuccesful = false;
        CustomEntityList customEntity = CustomEntityList.getByEntity((Entity)this);
        if (customEntity == null) {
            ProjectZuluLog.severe("Entity %s is Trying to Spawn but does not exist in the CustomEntityList. It will not spawn, please report this to Modder.", ((Object)((Object)this)).getClass().toString());
            return false;
        }
        if (((CustomMobData)customEntity.modData.get()).secondarySpawnRate - this.field_70146_Z.nextInt(100) >= 0 && super.func_70601_bi() && this.isValidLightLevel(this.field_70170_p, xCoord, yCoord, zCoord) && this.isValidLocation(this.field_70170_p, xCoord, yCoord, zCoord)) {
            wasSuccesful = true;
        }
        if (((CustomMobData)customEntity.modData.get()).reportSpawningInLog) {
            if (wasSuccesful) {
                ProjectZuluLog.info("Successfully spawned %s at X:%s Y:%s Z:%s in %s", this.func_70005_c_(), xCoord, yCoord, zCoord, this.field_70170_p.func_72807_a(xCoord, zCoord));
            } else {
                ProjectZuluLog.info("Failed to spawn %s at X:%s Y:%s Z:%s in %s, Spawning Location Inhospitable", this.func_70005_c_(), xCoord, yCoord, zCoord, this.field_70170_p.func_72807_a(xCoord, zCoord));
            }
        }
        return wasSuccesful;
    }

    protected boolean isValidLightLevel(World world, int xCoord, int yCoord, int zCoord) {
        return this.field_70170_p.func_72972_b(EnumSkyBlock.Block, xCoord, yCoord, zCoord) < 1;
    }

    protected boolean isValidLocation(World world, int xCoord, int yCoord, int zCoord) {
        return true;
    }

    protected void func_70628_a(boolean par1, int par2) {
        CustomEntityList customEntity = CustomEntityList.getByEntity((Entity)this);
        if (customEntity != null) {
            Collection<ItemStack> loot = ((CustomMobData)customEntity.modData.get()).getLoot(this.field_70146_Z, par2);
            for (ItemStack itemStack : loot) {
                if (itemStack == null) continue;
                this.func_70099_a(itemStack, 1.0f);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74757_a("ForceDespawn", this.forceDespawn);
    }

    @Override
    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.forceDespawn = par1nbtTagCompound.func_74767_n("ForceDespawn");
    }
}

