/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.core.ConfigHelper;
import com.stek101.projectzulu.common.core.ItemGenerics;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityBrownBear;
import com.stek101.projectzulu.common.mobs.models.ModelBrownBear;
import com.stek101.projectzulu.common.mobs.renders.RenderGenericLiving;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class BearBrownDeclaration
extends SpawnableDeclaration {
    public BearBrownDeclaration() {
        super("Brown Bear", 17, EntityBrownBear.class, EnumCreatureType.creature);
        this.setSpawnProperties(10, 100, 1, 2);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 2);
        this.eggColor1 = 3351048;
        this.eggColor2 = 4139530;
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, Items.field_151082_bd, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.furPelt, 0, 8);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.scrapMeat, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.BlackLichen.meta(), 4);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.SmallHeart.meta(), 4);
        customMobData.entityProperties = new EntityProperties(20.0f, 4.0f, 0.3f, 0.0f, 0.0f, 32.0f, 50.0f, 16.0).createFromConfig(config, this.mobName);
        super.outputDataToList(config, customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderGenericLiving(new ModelBrownBear(), 0.5f, new ResourceLocation("projectzulumob", "textures/bearbrown.png"));
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76767_f.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76785_t.field_76791_y);
        defaultBiomesToSpawn.add("Autumn Woods");
        defaultBiomesToSpawn.add("Birch Forest");
        defaultBiomesToSpawn.add("Forested Hills");
        defaultBiomesToSpawn.add("Forested Island");
        defaultBiomesToSpawn.add("Mountain Taiga");
        defaultBiomesToSpawn.add("Redwood Forest");
        defaultBiomesToSpawn.add("Lush Redwoods");
        defaultBiomesToSpawn.add("Snow Forest");
        defaultBiomesToSpawn.add("Temperate Rainforest");
        defaultBiomesToSpawn.add("Woodlands");
        HashSet<String> nonFrozenForest = new HashSet<String>();
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.FOREST));
        nonFrozenForest.removeAll(this.typeToArray(BiomeDictionary.Type.FROZEN));
        defaultBiomesToSpawn.addAll(nonFrozenForest);
        return defaultBiomesToSpawn;
    }
}

