/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.core.ConfigHelper;
import com.stek101.projectzulu.common.core.ItemGenerics;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityFox;
import com.stek101.projectzulu.common.mobs.models.ModelFox;
import com.stek101.projectzulu.common.mobs.renders.RenderTameable;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class FoxDeclaration
extends SpawnableDeclaration {
    public FoxDeclaration() {
        super("Fox", 9, EntityFox.class, EnumCreatureType.creature);
        this.setSpawnProperties(10, 100, 1, 3);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 2);
        this.eggColor1 = 13403158;
        this.eggColor2 = 0xE0E0E0;
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, Items.field_151082_bd, 0, 5);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.furPelt, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.scrapMeat, 0, 15);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.SmallHeart.meta(), 4);
        customMobData.entityProperties = new EntityProperties(12.0f, 2.0f, 0.3f, 100.0f, 0.0f, 32.0f, 30.0f, 16.0).createFromConfig(config, this.mobName);
        super.outputDataToList(config, customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderTameable(new ModelFox(), 0.5f, new ResourceLocation("projectzulumob", "textures/fox.png"));
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76768_g.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76784_u.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76767_f.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76785_t.field_76791_y);
        defaultBiomesToSpawn.add("Birch Forest");
        defaultBiomesToSpawn.add("Forested Island");
        defaultBiomesToSpawn.add("Forested Hills");
        defaultBiomesToSpawn.add("Green Hills");
        defaultBiomesToSpawn.add("Mountain Taiga");
        defaultBiomesToSpawn.add("Pine Forest");
        defaultBiomesToSpawn.add("Rainforest");
        defaultBiomesToSpawn.add("Redwood Forest");
        defaultBiomesToSpawn.add("Lush Redwoods");
        defaultBiomesToSpawn.add("Snow Forest");
        defaultBiomesToSpawn.add("Snowy Rainforest");
        defaultBiomesToSpawn.add("Temperate Rainforest");
        defaultBiomesToSpawn.add("Woodlands");
        defaultBiomesToSpawn.addAll(this.typeToArray(BiomeDictionary.Type.FOREST));
        return defaultBiomesToSpawn;
    }
}

