/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.mobs.entitydefaults;

import com.stek101.projectzulu.common.api.CustomMobData;
import com.stek101.projectzulu.common.api.ItemList;
import com.stek101.projectzulu.common.core.ConfigHelper;
import com.stek101.projectzulu.common.core.ItemGenerics;
import com.stek101.projectzulu.common.core.entitydeclaration.EntityProperties;
import com.stek101.projectzulu.common.core.entitydeclaration.SpawnableDeclaration;
import com.stek101.projectzulu.common.mobs.entity.EntityVulture;
import com.stek101.projectzulu.common.mobs.models.ModelVulture;
import com.stek101.projectzulu.common.mobs.renders.RenderGenericLiving;
import com.stek101.projectzulu.common.mobs.renders.RenderWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public class VultureDeclaration
extends SpawnableDeclaration {
    public VultureDeclaration() {
        super("Vulture", 6, EntityVulture.class, EnumCreatureType.monster);
        this.setSpawnProperties(2, 5, 1, 3);
        this.setRegistrationProperties(128, 3, true);
        this.setDropAmount(0, 2);
        this.eggColor1 = 5130296;
        this.eggColor2 = 7892566;
    }

    @Override
    public void outputDataToList(Configuration config, CustomMobData customMobData) {
        customMobData.customData.put("maxTargetHealth", config.get("MOB CONTROLS." + this.mobName, "Max Target Health To Attack", 20).getInt(20));
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, Items.field_151008_G, 0, 8);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, Items.field_151076_bf, 0, 10);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.SmallHeart.meta(), 4);
        ConfigHelper.configDropToMobData(config, "MOB CONTROLS." + this.mobName, customMobData, ItemList.genericCraftingItems, ItemGenerics.Properties.Talon.meta(), 4);
        customMobData.entityProperties = new EntityProperties(14.0f, 3.0f, 0.18f).createFromConfig(config, this.mobName);
        super.outputDataToList(config, customMobData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderWrapper getEntityrender(Class<? extends EntityLivingBase> entityClass) {
        return new RenderGenericLiving(new ModelVulture(), 0.5f, new ResourceLocation("projectzulumob", "textures/vulture.png"));
    }

    @Override
    public HashSet<String> getDefaultBiomesToSpawn() {
        HashSet<String> defaultBiomesToSpawn = new HashSet<String>();
        defaultBiomesToSpawn.add(BiomeGenBase.field_76769_d.field_76791_y);
        defaultBiomesToSpawn.add(BiomeGenBase.field_76786_s.field_76791_y);
        defaultBiomesToSpawn.add("Mountainous Desert");
        defaultBiomesToSpawn.add("Mountain Ridge");
        defaultBiomesToSpawn.add("Wasteland");
        HashSet<String> nonFrozenForest = new HashSet<String>();
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.DESERT));
        nonFrozenForest.addAll(this.typeToArray(BiomeDictionary.Type.WASTELAND));
        nonFrozenForest.removeAll(this.typeToArray(BiomeDictionary.Type.FROZEN));
        defaultBiomesToSpawn.addAll(nonFrozenForest);
        return defaultBiomesToSpawn;
    }
}

