/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.potion;

import com.google.common.base.Optional;
import com.stek101.projectzulu.common.api.PotionList;
import com.stek101.projectzulu.common.core.ObfuscationHelper;
import com.stek101.projectzulu.common.potion.PotionEventHookContainerClass;
import com.stek101.projectzulu.common.potion.effects.PotionCleansing;
import com.stek101.projectzulu.common.potion.effects.PotionCurse;
import com.stek101.projectzulu.common.potion.effects.PotionHarm2;
import com.stek101.projectzulu.common.potion.effects.PotionHeal2;
import com.stek101.projectzulu.common.potion.effects.PotionIncendiary;
import com.stek101.projectzulu.common.potion.effects.PotionSlowFall;
import com.stek101.projectzulu.common.potion.effects.PotionThorns;
import com.stek101.projectzulu.common.potion.effects.PotionZulu;
import java.lang.reflect.Array;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

public enum PotionManager {
    bubbling(21){

        @Override
        protected void setupPotion() {
            PotionList.bubbling = Optional.of((Object)new PotionZulu(this.potionID, true, 10847046, 1, 2).func_76390_b("potion.shining"));
        }

        @Override
        protected void registerPotion() {
        }
    }
    ,
    incendiary(22){

        @Override
        protected void setupPotion() {
            PotionList.incendiary = Optional.of((Object)new PotionIncendiary(this.potionID, true, 8733978).func_76390_b("potion.incendiary"));
        }

        @Override
        protected void registerPotion() {
        }
    }
    ,
    slowfall(23){

        @Override
        protected void setupPotion() {
            PotionList.slowfall = Optional.of((Object)new PotionSlowFall(this.potionID, true, 0xD6D6D6).func_76390_b("potion.slowfall"));
        }

        @Override
        protected void registerPotion() {
        }
    }
    ,
    cleansing(24){

        @Override
        protected void setupPotion() {
            PotionList.cleansing = Optional.of((Object)new PotionCleansing(this.potionID, true, 9279823).func_76390_b("potion.cleansing"));
        }

        @Override
        protected void registerPotion() {
        }
    }
    ,
    curse(25){

        @Override
        protected void setupPotion() {
            PotionList.curse = Optional.of((Object)new PotionCurse(this.potionID, true, 7512116).func_76390_b("potion.curse"));
        }

        @Override
        protected void registerPotion() {
        }
    }
    ,
    thorn(26){

        @Override
        protected void setupPotion() {
            PotionList.thorn = Optional.of((Object)new PotionThorns(this.potionID, true, 1213730).func_76390_b("potion.thorn"));
        }

        @Override
        protected void registerPotion() {
        }
    }
    ,
    heal2(27){

        @Override
        protected void setupPotion() {
            PotionList.heal2 = Optional.of((Object)new PotionHeal2(this.potionID, false).func_76390_b("potion.heal2"));
        }

        @Override
        protected void registerPotion() {
        }
    }
    ,
    harm2(28){

        @Override
        protected void setupPotion() {
            PotionList.harm2 = Optional.of((Object)new PotionHarm2(this.potionID, true).func_76390_b("potion.harm2"));
        }

        @Override
        protected void registerPotion() {
        }
    };

    int potionID;
    public static boolean potionModuleEnabled;
    public static boolean enableNullPotionHandler;
    public static boolean potionIDAuto;
    public static int customPotionOffset;
    public static int customPotionLength;

    protected abstract void setupPotion();

    protected abstract void registerPotion();

    private PotionManager(int potionID) {
        this.potionID = potionID;
    }

    public static void loadSettings(Configuration config) {
        potionIDAuto = config.get("Potion Controls", "Potion AutoID Option", potionIDAuto).getBoolean(potionIDAuto);
        potionModuleEnabled = config.get("Potion Controls", "Potion Module Enabled", potionModuleEnabled).getBoolean(potionModuleEnabled);
        enableNullPotionHandler = config.get("Potion Controls", "Enable Null Potion Handler", enableNullPotionHandler).getBoolean(enableNullPotionHandler);
        for (PotionManager potion : PotionManager.values()) {
            potion.potionID = config.get("Potion Controls." + potion.toString(), "PotionID", potion.potionID).getInt(potion.potionID);
        }
    }

    public static void setupAndRegisterPotions() {
        PotionManager.increaseVanillaPotionArray(64);
        for (PotionManager potion : PotionManager.values()) {
            if (potionIDAuto) {
                potion.potionID = PotionManager.getNextPotionID();
            }
            potion.setupPotion();
            potion.registerPotion();
        }
        if (PotionList.cleansing.isPresent() || PotionList.thorn.isPresent()) {
            MinecraftForge.EVENT_BUS.register((Object)new PotionEventHookContainerClass());
        }
    }

    private static void increaseVanillaPotionArray(int newSize) {
        Potion[] a;
        Class<?> potionClass;
        int originalLength;
        int vanillaLength = 32;
        int safeLength = 128;
        int newLength = originalLength = Potion.field_76425_a.length;
        if (originalLength < safeLength) {
            newLength = originalLength + customPotionLength;
        }
        customPotionOffset = Math.min(originalLength, safeLength - 1 - customPotionLength);
        if (originalLength < safeLength && (potionClass = (a = Potion.field_76425_a).getClass()).isArray()) {
            int length = Array.getLength(a);
            Class<?> componentType = a.getClass().getComponentType();
            Potion[] newArray = (Potion[])Array.newInstance(componentType, newLength);
            System.arraycopy(a, 0, newArray, 0, length);
            try {
                ObfuscationHelper.setCatchableFieldUsingReflection("field_76425_a", Potion.class, Potion[].class, false, true, newArray);
            }
            catch (NoSuchFieldException e) {
                ObfuscationHelper.setFieldUsingReflection("potionTypes", Potion.class, Potion[].class, false, true, newArray);
            }
        }
    }

    public static int getNextPotionID() {
        return customPotionOffset++;
    }

    static {
        potionModuleEnabled = true;
        enableNullPotionHandler = true;
        potionIDAuto = true;
        customPotionOffset = 0;
        customPotionLength = 24;
    }
}

