/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.potion.subitem;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.stek101.projectzulu.common.core.ProjectZuluLog;
import com.stek101.projectzulu.common.potion.PotionParser;
import com.stek101.projectzulu.common.potion.subitem.SubItemPotion;
import java.util.Collection;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum SubItemPotionRegistry {
    INSTANCE;

    private Table<Item, Integer, SubItemPotion> subPotions = HashBasedTable.create((int)2, (int)16);
    private Table<Item, String, Integer> itemAndNameToSubIDMap = HashBasedTable.create((int)2, (int)16);

    public void addSubPotions(SubItemPotion ... potionSubItems) {
        for (SubItemPotion subItemPotion : potionSubItems) {
            if (this.subPotions.row((Object)subItemPotion.item).keySet().contains(subItemPotion.subID)) {
                ProjectZuluLog.info("Potion Conflict: Replacing Potion at %s:%s with %s", subItemPotion.item, subItemPotion.subID, subItemPotion.baseName);
            }
            this.subPotions.put((Object)subItemPotion.item, (Object)subItemPotion.subID, (Object)subItemPotion);
            this.itemAndNameToSubIDMap.put((Object)subItemPotion.item, (Object)subItemPotion.baseName, (Object)subItemPotion.subID);
        }
    }

    public Collection<SubItemPotion> getPotions(Item item) {
        return this.subPotions.row((Object)item).values();
    }

    public SubItemPotion getPotion(ItemStack itemStack) {
        return this.getPotion(itemStack.func_77973_b(), PotionParser.readID(itemStack.func_77960_j()));
    }

    public SubItemPotion getPotion(Item itemID, int subID) {
        return (SubItemPotion)this.subPotions.get((Object)itemID, (Object)subID);
    }

    public SubItemPotion getPotion(int itemID, String name) {
        Integer subID = (Integer)this.itemAndNameToSubIDMap.get((Object)itemID, (Object)name);
        return subID != null ? (SubItemPotion)this.subPotions.get((Object)itemID, (Object)subID) : null;
    }

    public boolean isItemPotion(ItemStack itemStack) {
        return itemStack != null ? this.subPotions.get((Object)itemStack.func_77973_b(), (Object)PotionParser.readID(itemStack.func_77960_j())) != null : false;
    }

    public boolean isItemPotion(Item itemID) {
        return !this.subPotions.row((Object)itemID).isEmpty();
    }
}

