/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world.retroGenerator;

import com.stek101.projectzulu.common.world.retroGenerator.Location;
import net.minecraft.world.chunk.Chunk;

public class ChunkCoord {
    public int chunkX;
    public int chunkZ;

    public ChunkCoord(Chunk chunk) {
        this.chunkX = chunk.field_76635_g;
        this.chunkZ = chunk.field_76647_h;
    }

    public ChunkCoord(int x, int z) {
        this.chunkX = x;
        this.chunkZ = z;
    }

    public ChunkCoord() {
        this(0, 0);
    }

    public ChunkCoord(ChunkCoord cCoord) {
        this.chunkX = cCoord.chunkX;
        this.chunkZ = cCoord.chunkZ;
    }

    public int getCenterX() {
        return (this.chunkX << 4) + 8;
    }

    public int getCenterZ() {
        return (this.chunkZ << 4) + 8;
    }

    public boolean isEqual(ChunkCoord cCoord) {
        return this.chunkX == cCoord.chunkX && this.chunkZ == cCoord.chunkZ;
    }

    public static ChunkCoord getChunkCoordFromBlockCoords(int x, int z) {
        int chunkX = (int)Math.floor(x / 16);
        int chunkZ = (int)Math.floor(z / 16);
        return new ChunkCoord(chunkX, chunkZ);
    }

    public static ChunkCoord getChunkCoordFromBlockCoord(Location bCoord) {
        return ChunkCoord.getChunkCoordFromBlockCoords(bCoord.x, bCoord.z);
    }

    public Object clone() {
        return new ChunkCoord(this);
    }

    public String toString() {
        return "ChunkCoord: [chunkX: " + this.chunkX + ", chunkZ: " + this.chunkZ + "]";
    }

    public int hashCode() {
        return ("chunkX:" + this.chunkX + "chunkZ:" + this.chunkZ).hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ChunkCoord && this.isEqual((ChunkCoord)obj);
    }
}

