/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world.retroGenerator;

import com.google.common.collect.Lists;
import com.stek101.projectzulu.common.world.retroGenerator.ChunkCoord;
import com.stek101.projectzulu.common.world.retroGenerator.IRetroGenerator;
import com.stek101.projectzulu.common.world.retroGenerator.RetroGenSaveData;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;

public class RetroactiveWorldGenerator {
    private static ArrayList<IRetroGenerator> generators = Lists.newArrayList();
    private static ArrayList<RetroGenEntry> genQueue = Lists.newArrayList();
    public static final String retroGenSaveDataName = "mc_retroDATA";

    public static void registerRetroGenerator(IRetroGenerator generator) {
        generators.add(generator);
    }

    private RetroGenSaveData getRetroGenSaveData(World world) {
        RetroGenSaveData data = (RetroGenSaveData)world.perWorldStorage.func_75742_a(RetroGenSaveData.class, retroGenSaveDataName);
        if (data == null) {
            data = new RetroGenSaveData(retroGenSaveDataName);
            world.perWorldStorage.func_75745_a(retroGenSaveDataName, (WorldSavedData)data);
        }
        return data;
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        RetroGenSaveData data = this.getRetroGenSaveData(event.world);
        ChunkCoord coord = new ChunkCoord(event.getChunk());
        World world = event.world;
        Chunk chunk = event.getChunk();
        for (IRetroGenerator gen : generators) {
            if (!gen.canGenerateIn(world, chunk, new Random()) || !data.isGenerationNeeded(coord, gen.getUniqueGenerationID())) continue;
            genQueue.add(new RetroGenEntry(world, coord, gen));
            data.markChunkRetroGenerated(coord, gen.getUniqueGenerationID());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (genQueue.isEmpty()) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        int count = 0;
        ArrayList removeQueue = Lists.newArrayList();
        ArrayList iterationQueue = (ArrayList)genQueue.clone();
        for (RetroGenEntry entry : iterationQueue) {
            entry.gen.generate(entry.world.field_73012_v, entry.world, entry.coord.chunkX, entry.coord.chunkZ);
            removeQueue.add(entry);
            if (++count < 32) continue;
            break;
        }
        genQueue.removeAll(removeQueue);
    }

    public class RetroGenEntry {
        World world;
        ChunkCoord coord;
        IRetroGenerator gen;

        public RetroGenEntry(World world, ChunkCoord coord, IRetroGenerator gen) {
            this.world = world;
            this.coord = coord;
            this.gen = gen;
        }
    }
}

