/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world2.BoundaryPair;
import com.stek101.projectzulu.common.world2.MazeCell;
import java.awt.Point;
import net.minecraft.util.ChunkCoordinates;

public class CellHelper {
    public static ChunkCoordinates rotateCellTo(ChunkCoordinates piecePos, int cellSize, CellIndexDirection cellIndexDirection) {
        if (cellIndexDirection == CellIndexDirection.NorthWall) {
            return new ChunkCoordinates(piecePos.field_71574_a, piecePos.field_71572_b, piecePos.field_71573_c);
        }
        if (cellIndexDirection == CellIndexDirection.SouthWall) {
            return new ChunkCoordinates(cellSize - 1 - piecePos.field_71574_a, piecePos.field_71572_b, cellSize - 1 - piecePos.field_71573_c);
        }
        if (cellIndexDirection == CellIndexDirection.WestWall) {
            return new ChunkCoordinates(cellSize - 1 - piecePos.field_71573_c, piecePos.field_71572_b, piecePos.field_71574_a);
        }
        if (cellIndexDirection == CellIndexDirection.EastWall) {
            return new ChunkCoordinates(piecePos.field_71573_c, piecePos.field_71572_b, cellSize - 1 - piecePos.field_71574_a);
        }
        return piecePos;
    }

    public static ChunkCoordinates mirrorCellTo(ChunkCoordinates piecePos, int cellSize, CellIndexDirection cellIndexDirection) {
        if (cellIndexDirection == CellIndexDirection.NorthWestCorner) {
            return new ChunkCoordinates(piecePos.field_71574_a, piecePos.field_71572_b, piecePos.field_71573_c);
        }
        if (cellIndexDirection == CellIndexDirection.SouthWestCorner) {
            return new ChunkCoordinates(piecePos.field_71574_a, piecePos.field_71572_b, cellSize - 1 - piecePos.field_71573_c);
        }
        if (cellIndexDirection == CellIndexDirection.NorthEastCorner) {
            return new ChunkCoordinates(cellSize - 1 - piecePos.field_71574_a, piecePos.field_71572_b, piecePos.field_71573_c);
        }
        if (cellIndexDirection == CellIndexDirection.SouthEastCorner) {
            return new ChunkCoordinates(cellSize - 1 - piecePos.field_71574_a, piecePos.field_71572_b, cellSize - 1 - piecePos.field_71573_c);
        }
        return piecePos;
    }

    public static boolean isCorner(MazeCell[][] cells, Point buildCoords) {
        if (buildCoords.x == 0 && (buildCoords.y == 0 || buildCoords.y == cells[0].length - 1)) {
            return true;
        }
        return buildCoords.x == cells.length - 1 && (buildCoords.y == 0 || buildCoords.y == cells[0].length - 1);
    }

    public static int getSlopeIndex(ChunkCoordinates piecePos, int directionIndex, float slopeSpacing, BoundaryPair<Integer, Integer> indexBoundary, int highestPoint) {
        int distanceFromTop = highestPoint - piecePos.field_71572_b;
        int corectDirecIndex = Math.min(Math.max(directionIndex, indexBoundary.getLowerLimit()), indexBoundary.getUpperLimit());
        return (int)((float)corectDirecIndex / slopeSpacing) - distanceFromTop;
    }
}

