/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2;

import java.util.EnumSet;
import java.util.Random;

public enum Direction {
    U(0, 0, 1),
    D(1, 0, -1),
    L(2, 1, 0),
    R(3, -1, 0),
    UL(4, 1, 1),
    UR(5, -1, 1),
    DL(6, 1, -1),
    DR(7, -1, -1);

    public final int x;
    public final int z;
    public final int id;
    public static final Direction[] invert;
    public static final Direction[] cwRotation;
    public static final Direction[] ccwRotation;

    private Direction(int id, int x, int z) {
        this.id = id;
        this.x = x;
        this.z = z;
    }

    public Direction invert() {
        return invert[this.id];
    }

    public Direction rotateOrdinal(boolean clockwise) {
        return clockwise ? cwRotation[this.id] : ccwRotation[this.id];
    }

    public static Direction getCardinal(Random random) {
        return Direction.getCardinal(random.nextInt(4));
    }

    public static Direction getCardinal(int id) {
        id &= 3;
        for (Direction direction : Direction.values()) {
            if (direction.id != id) continue;
            return direction;
        }
        throw new IllegalArgumentException("ID provided " + Integer.toString(id) + " is not a Direction");
    }

    public static EnumSet<Direction> getCardinals() {
        return EnumSet.of(U, D, L, R);
    }

    public static Direction getOrdinal(Random random) {
        return Direction.getOrdinal(random.nextInt(8));
    }

    public static Direction getOrdinal(int id) {
        id &= 7;
        for (Direction direction : Direction.values()) {
            if (direction.id != id) continue;
            return direction;
        }
        throw new IllegalArgumentException("ID provided " + Integer.toString(id) + " is not a Direction");
    }

    public static EnumSet<Direction> getOrdinals() {
        return EnumSet.of(U, new Direction[]{D, L, R, UL, UR, DL, DR});
    }

    static {
        invert = new Direction[]{D, U, R, L, DR, DL, UR, UL};
        cwRotation = new Direction[]{UR, DL, UL, DR, U, R, L, D};
        ccwRotation = new Direction[]{UL, DR, DL, UR, L, U, D, R};
    }
}

