/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.architect;

import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class BlueprintSetStockpile {
    private HashMap<String, BlueprintSet> blueprintSetList = new HashMap();
    public Random random;

    BlueprintSetStockpile(Random random) {
        this.random = random;
    }

    public void addBlueprintSet(BlueprintSet blueprintSet) {
        if (blueprintSet == null || this.blueprintSetList.containsKey(blueprintSet.getIdentifier())) {
            throw new IllegalArgumentException("BlueprintSet " + blueprintSet == null ? "cannot be null" : "ID is already taken");
        }
        this.blueprintSetList.put(blueprintSet.getIdentifier(), blueprintSet);
    }

    public BlueprintSet getBlueprintSet(String setID) {
        return this.blueprintSetList.get(setID);
    }

    public BlueprintSet getBlueprintSet(MazeCell cell) {
        String[] parts = cell.getBuildingID().split("-");
        String setCategory = parts[0];
        return this.blueprintSetList.get(setCategory);
    }

    public BlueprintSet getRandomApplicable(MazeCell[][] cells, Point buildCoords) {
        int totalWeight = 0;
        ArrayList<BlueprintSet> applicableSets = new ArrayList<BlueprintSet>();
        for (BlueprintSet set : this.blueprintSetList.values()) {
            if (!set.isApplicable(cells, buildCoords, this.random) || set.getWeight() <= 0) continue;
            totalWeight += set.getWeight();
            applicableSets.add(set);
        }
        totalWeight = this.random.nextInt(totalWeight + 1);
        for (BlueprintSet set : applicableSets) {
            if ((totalWeight -= set.getWeight()) > 0) continue;
            return set;
        }
        return null;
    }
}

