/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint.cathedral;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.BoundaryPair;
import com.stek101.projectzulu.common.world2.CellHelper;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandom;

public class BPCathedralDome
implements Blueprint {
    List<BlockWithMeta> wallBlocks = new ArrayList<BlockWithMeta>(3);

    public BPCathedralDome() {
        this.wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 2, 5));
        this.wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 1, 10));
        this.wallBlocks.add(new BlockWithMeta(Blocks.field_150417_aV, 0, 100));
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        if (cellIndexDirection == CellIndexDirection.NorthWestCorner) {
            return this.getDomeBlock(CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.NorthWall), cellSize, cellHeight, random, cellIndexDirection);
        }
        if (cellIndexDirection == CellIndexDirection.NorthEastCorner) {
            return this.getDomeBlock(CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.EastWall), cellSize, cellHeight, random, cellIndexDirection);
        }
        if (cellIndexDirection == CellIndexDirection.SouthWestCorner) {
            return this.getDomeBlock(CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.WestWall), cellSize, cellHeight, random, cellIndexDirection);
        }
        if (cellIndexDirection == CellIndexDirection.SouthEastCorner) {
            return this.getDomeBlock(CellHelper.rotateCellTo(piecePos, cellSize, CellIndexDirection.SouthWall), cellSize, cellHeight, random, cellIndexDirection);
        }
        return new BlockWithMeta(Blocks.field_150350_a);
    }

    private BlockWithMeta getDomeBlock(ChunkCoordinates piecePos, int cellSize, int cellHeight, Random random, CellIndexDirection cellIndexDirection) {
        int diagonalIndex = piecePos.field_71573_c + piecePos.field_71574_a;
        int domeFloor = cellHeight - (cellSize + 1);
        BlockWithMeta woodenPlank = new BlockWithMeta(Blocks.field_150344_f, 1);
        if (piecePos.field_71572_b > domeFloor) {
            int slope = CellHelper.getSlopeIndex(piecePos, 2 * cellSize - diagonalIndex - 1, 2.0f, BoundaryPair.createPair(cellSize - 4, cellSize * 2), cellHeight);
            if (slope == 0) {
                return woodenPlank;
            }
            if (slope > 0) {
                return new BlockWithMeta(Blocks.field_150350_a);
            }
            if (piecePos.field_71574_a == 0) {
                return piecePos.field_71573_c % 2 == 0 ? (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, this.wallBlocks) : new BlockWithMeta(Blocks.field_150350_a);
            }
            if (piecePos.field_71573_c == 0) {
                return piecePos.field_71574_a % 2 == 0 ? (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, this.wallBlocks) : new BlockWithMeta(Blocks.field_150350_a);
            }
        }
        if (piecePos.field_71572_b == domeFloor && diagonalIndex > 2 && diagonalIndex < cellSize * 2 - 3) {
            return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, this.wallBlocks);
        }
        if (piecePos.field_71572_b == domeFloor + 1 && diagonalIndex == cellSize * 2 - 4) {
            return new BlockWithMeta(Blocks.field_150411_aY);
        }
        if (piecePos.field_71572_b == domeFloor + 1 && diagonalIndex == cellSize * 2 - 5 && piecePos.field_71574_a != cellSize - 1 && piecePos.field_71573_c != cellSize - 1) {
            return new BlockWithMeta(Blocks.field_150411_aY);
        }
        if (diagonalIndex == 2) {
            return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, this.wallBlocks);
        }
        if (piecePos.field_71572_b == 0 && diagonalIndex > 2) {
            if (diagonalIndex == 3) {
                return new BlockWithMeta(Blocks.field_150347_e);
            }
            return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, this.wallBlocks);
        }
        if (diagonalIndex > 6) {
            if (piecePos.field_71572_b == 1) {
                return (BlockWithMeta)WeightedRandom.func_76271_a((Random)random, this.wallBlocks);
            }
            if (piecePos.field_71572_b == 2) {
                if (cellIndexDirection == CellIndexDirection.SouthEastCorner) {
                    if (piecePos.field_71573_c >= cellSize - 3 && piecePos.field_71574_a == cellSize - 2) {
                        return new BlockWithMeta(Blocks.field_150390_bg, 1);
                    }
                    if (piecePos.field_71573_c == cellSize - 3 && piecePos.field_71574_a > cellSize - 2) {
                        return new BlockWithMeta(Blocks.field_150390_bg, 3);
                    }
                } else if (cellIndexDirection == CellIndexDirection.SouthWestCorner) {
                    if (piecePos.field_71574_a >= cellSize - 3 && piecePos.field_71573_c == cellSize - 2) {
                        return new BlockWithMeta(Blocks.field_150390_bg, 0);
                    }
                    if (piecePos.field_71574_a == cellSize - 3 && piecePos.field_71573_c > cellSize - 2) {
                        return new BlockWithMeta(Blocks.field_150390_bg, 3);
                    }
                }
                return new BlockWithMeta((Block)Blocks.field_150333_U, 5);
            }
            if (piecePos.field_71572_b == 3 && (cellIndexDirection == CellIndexDirection.SouthEastCorner ? piecePos.field_71573_c == cellSize - 2 && piecePos.field_71574_a > cellSize - 2 : cellIndexDirection == CellIndexDirection.SouthWestCorner && piecePos.field_71574_a == cellSize - 2 && piecePos.field_71573_c > cellSize - 2)) {
                return new BlockWithMeta((Block)Blocks.field_150333_U, 5);
            }
        }
        if (piecePos.field_71572_b == 1) {
            if (diagonalIndex == 6 && piecePos.field_71573_c == cellSize - 1 && cellIndexDirection == CellIndexDirection.NorthEastCorner || diagonalIndex == 6 && piecePos.field_71574_a == cellSize - 1 && cellIndexDirection == CellIndexDirection.NorthWestCorner) {
                return new BlockWithMeta(Blocks.field_150390_bg, 2);
            }
            if (diagonalIndex > 4) {
                return new BlockWithMeta(Blocks.field_150404_cg, 14);
            }
        }
        return new BlockWithMeta(Blocks.field_150350_a);
    }

    @Override
    public String getIdentifier() {
        return "CathedralDome";
    }

    @Override
    public int getWeight() {
        return 0;
    }
}

