/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.blueprint.cathedral;

import com.stek101.projectzulu.common.world.CellIndexDirection;
import com.stek101.projectzulu.common.world.dataobjects.BlockWithMeta;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.blueprint.Blueprint;
import com.stek101.projectzulu.common.world2.blueprint.BlueprintSet;
import com.stek101.projectzulu.common.world2.blueprint.cathedral.BPCathedralDome;
import com.stek101.projectzulu.common.world2.blueprint.cathedral.BPCathedralEastTower;
import com.stek101.projectzulu.common.world2.blueprint.cathedral.BPCathedralEntrance;
import com.stek101.projectzulu.common.world2.blueprint.cathedral.BPCathedralHallway;
import com.stek101.projectzulu.common.world2.blueprint.cathedral.BPCathedralHallwayEnd;
import com.stek101.projectzulu.common.world2.blueprint.cathedral.BPCathedralHallwayEntrance;
import com.stek101.projectzulu.common.world2.blueprint.cathedral.BPCathedralWestTower;
import java.awt.Point;
import java.util.Random;
import net.minecraft.util.ChunkCoordinates;

public class BPSetCathedral
implements BlueprintSet {
    boolean isAssigned = false;
    Blueprint dome = new BPCathedralDome();
    Blueprint hallway = new BPCathedralHallway();
    Blueprint hallwayEnd = new BPCathedralHallwayEnd();
    Blueprint hallwayEnt = new BPCathedralHallwayEntrance();
    Blueprint entrance = new BPCathedralEntrance();
    Blueprint west_tower = new BPCathedralWestTower();
    Blueprint east_tower = new BPCathedralEastTower();

    @Override
    public boolean isApplicable(MazeCell[][] cells, Point buildCoords, Random random) {
        return !this.isAssigned;
    }

    @Override
    public boolean assignCellsWithBlueprints(MazeCell[][] cells, Point buildCoords, Random random) {
        this.applyBlueprintToCell(cells, buildCoords.x + 2, buildCoords.y + 2, this.dome.getIdentifier(), CellIndexDirection.NorthWestCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 3, buildCoords.y + 2, this.dome.getIdentifier(), CellIndexDirection.NorthEastCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 2, buildCoords.y + 3, this.dome.getIdentifier(), CellIndexDirection.SouthWestCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 3, buildCoords.y + 3, this.dome.getIdentifier(), CellIndexDirection.SouthEastCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 2, buildCoords.y + 4, this.hallwayEnt.getIdentifier(), CellIndexDirection.WestWall);
        this.applyBlueprintToCell(cells, buildCoords.x + 3, buildCoords.y + 4, this.hallwayEnt.getIdentifier(), CellIndexDirection.EastWall);
        this.applyBlueprintToCell(cells, buildCoords.x + 2, buildCoords.y + 1, this.hallway.getIdentifier(), CellIndexDirection.WestWall);
        this.applyBlueprintToCell(cells, buildCoords.x + 3, buildCoords.y + 1, this.hallway.getIdentifier(), CellIndexDirection.EastWall);
        this.applyBlueprintToCell(cells, buildCoords.x + 1, buildCoords.y + 3, this.hallwayEnd.getIdentifier(), CellIndexDirection.NorthWestCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 1, buildCoords.y + 2, this.hallwayEnd.getIdentifier(), CellIndexDirection.NorthWall);
        this.applyBlueprintToCell(cells, buildCoords.x + 2, buildCoords.y + 0, this.hallwayEnd.getIdentifier(), CellIndexDirection.NorthEastCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 3, buildCoords.y + 0, this.hallwayEnd.getIdentifier(), CellIndexDirection.EastWall);
        this.applyBlueprintToCell(cells, buildCoords.x + 4, buildCoords.y + 2, this.hallwayEnd.getIdentifier(), CellIndexDirection.SouthEastCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 4, buildCoords.y + 3, this.hallwayEnd.getIdentifier(), CellIndexDirection.SouthWall);
        this.applyBlueprintToCell(cells, buildCoords.x + 2, buildCoords.y + 5, this.entrance.getIdentifier(), CellIndexDirection.NorthWestCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 3, buildCoords.y + 5, this.entrance.getIdentifier(), CellIndexDirection.NorthEastCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 2, buildCoords.y + 6, this.entrance.getIdentifier(), CellIndexDirection.SouthWestCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 3, buildCoords.y + 6, this.entrance.getIdentifier(), CellIndexDirection.SouthEastCorner);
        this.applyBlueprintToCell(cells, buildCoords.x + 0, buildCoords.y + 5, this.west_tower.getIdentifier(), CellIndexDirection.NorthWestCorner, cells[buildCoords.x + 0][buildCoords.y + 5].getHeight());
        this.applyBlueprintToCell(cells, buildCoords.x + 1, buildCoords.y + 5, this.west_tower.getIdentifier(), CellIndexDirection.NorthEastCorner, cells[buildCoords.x + 1][buildCoords.y + 5].getHeight());
        this.applyBlueprintToCell(cells, buildCoords.x + 0, buildCoords.y + 6, this.west_tower.getIdentifier(), CellIndexDirection.SouthWestCorner, cells[buildCoords.x + 0][buildCoords.y + 6].getHeight());
        this.applyBlueprintToCell(cells, buildCoords.x + 1, buildCoords.y + 6, this.west_tower.getIdentifier(), CellIndexDirection.SouthEastCorner, cells[buildCoords.x + 1][buildCoords.y + 6].getHeight());
        this.applyBlueprintToCell(cells, buildCoords.x + 4, buildCoords.y + 5, this.east_tower.getIdentifier(), CellIndexDirection.NorthWestCorner, cells[buildCoords.x + 4][buildCoords.y + 5].getHeight());
        this.applyBlueprintToCell(cells, buildCoords.x + 5, buildCoords.y + 5, this.east_tower.getIdentifier(), CellIndexDirection.NorthEastCorner, cells[buildCoords.x + 5][buildCoords.y + 5].getHeight());
        this.applyBlueprintToCell(cells, buildCoords.x + 4, buildCoords.y + 6, this.east_tower.getIdentifier(), CellIndexDirection.SouthWestCorner, cells[buildCoords.x + 4][buildCoords.y + 6].getHeight());
        this.applyBlueprintToCell(cells, buildCoords.x + 5, buildCoords.y + 6, this.east_tower.getIdentifier(), CellIndexDirection.SouthEastCorner, cells[buildCoords.x + 5][buildCoords.y + 6].getHeight());
        this.isAssigned = true;
        return true;
    }

    private void applyBlueprintToCell(MazeCell[][] cellList, int xCell, int zCell, String subBuildingID, CellIndexDirection cellDirection) {
        this.applyBlueprintToCell(cellList, xCell, zCell, subBuildingID, cellDirection, 0);
    }

    private void applyBlueprintToCell(MazeCell[][] cellList, int xCell, int zCell, String subBuildingID, CellIndexDirection cellDirection, int heightIncrease) {
        cellList[xCell][zCell].setBuildingProperties(this.getIdentifier().concat("-").concat(subBuildingID), cellDirection);
        cellList[xCell][zCell].rawState = -1;
        cellList[xCell][zCell].setHeight(cellList[xCell][zCell].getHeight() + heightIncrease);
    }

    @Override
    public BlockWithMeta getBlockFromBlueprint(ChunkCoordinates piecePos, int cellSize, int cellHeight, CellIndexDirection cellIndexDirection, Random random, String buildingID) {
        String childBuildingID = buildingID.split("-")[1];
        if (childBuildingID != null) {
            if (childBuildingID.equals(this.dome.getIdentifier())) {
                return this.dome.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
            }
            if (childBuildingID.equals(this.hallway.getIdentifier())) {
                return this.hallway.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
            }
            if (childBuildingID.equals(this.hallwayEnd.getIdentifier())) {
                return this.hallwayEnd.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
            }
            if (childBuildingID.equals(this.hallwayEnt.getIdentifier())) {
                return this.hallwayEnt.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
            }
            if (childBuildingID.equals(this.entrance.getIdentifier())) {
                return this.entrance.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
            }
            if (childBuildingID.equals(this.west_tower.getIdentifier())) {
                return this.west_tower.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
            }
            if (childBuildingID.equals(this.east_tower.getIdentifier())) {
                return this.east_tower.getBlockFromBlueprint(piecePos, cellSize, cellHeight, random, cellIndexDirection);
            }
        }
        return null;
    }

    @Override
    public String getIdentifier() {
        return "Cathedral";
    }

    @Override
    public int getWeight() {
        return 20;
    }
}

