/*
 * Decompiled with CFR 0.152.
 */
package com.stek101.projectzulu.common.world2.randomizer;

import com.stek101.projectzulu.common.world2.Direction;
import com.stek101.projectzulu.common.world2.MazeCell;
import com.stek101.projectzulu.common.world2.randomizer.Randomizer;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.world.World;

public class WalledMazeRandomizer
extends Randomizer {
    Random random;

    public WalledMazeRandomizer(World world) {
        this.random = world.field_73012_v;
    }

    @Override
    public void randomize(MazeCell[][] allCells) {
        for (int i = 0; i < allCells.length; ++i) {
            int k = 0;
            allCells[i][k].rawState = 1;
            k = allCells[0].length - 1;
            allCells[i][k].rawState = 1;
        }
        for (int k = 0; k < allCells[0].length; ++k) {
            int i = 0;
            allCells[i][k].rawState = 1;
            i = allCells.length - 1;
            allCells[i][k].rawState = 1;
        }
        int attemptsSinceLastPlaced = 0;
        while (attemptsSinceLastPlaced < 800) {
            int randLength = this.random.nextInt(6) + 1;
            Direction direction = Direction.getCardinal(this.random);
            int selectedX = this.random.nextInt(allCells.length);
            int selectedZ = this.random.nextInt(allCells[0].length);
            while (allCells[selectedX][selectedZ].rawState != 1) {
                selectedX = this.random.nextInt(allCells.length);
                selectedZ = this.random.nextInt(allCells[0].length);
            }
            if (this.isCellWallValid(allCells, selectedX, selectedZ, direction, randLength)) {
                for (int i = 1; i <= randLength; ++i) {
                    int tempX = selectedX + direction.x * i;
                    int tempZ = selectedZ + direction.z * i;
                    allCells[tempX][tempZ].rawState = 1;
                }
                attemptsSinceLastPlaced = 0;
                continue;
            }
            ++attemptsSinceLastPlaced;
        }
    }

    protected boolean isCellWallValid(MazeCell[][] allCells, int selectedX, int selectedZ, Direction direction, int randLength) {
        for (int i = 1; i <= randLength; ++i) {
            int cellToPlaceX = selectedX + direction.x * i;
            int cellToPlaceZ = selectedZ + direction.z * i;
            if (this.isCellOutOfBounds(allCells, cellToPlaceX, cellToPlaceZ) || allCells[cellToPlaceX][cellToPlaceZ].rawState == 1) {
                return false;
            }
            EnumSet<Direction> neighbourDirections = Direction.getOrdinals();
            neighbourDirections.remove((Object)direction.invert());
            neighbourDirections.remove((Object)direction.invert().rotateOrdinal(true));
            neighbourDirections.remove((Object)direction.invert().rotateOrdinal(false));
            for (Direction cellDirection : neighbourDirections) {
                int neighbourCellX = cellToPlaceX + cellDirection.x;
                int neighbourCellZ = cellToPlaceZ + cellDirection.z;
                if (this.isCellOutOfBounds(allCells, neighbourCellX, neighbourCellZ)) continue;
                if (allCells[neighbourCellX][neighbourCellZ].rawState == 1) {
                    return false;
                }
                if (!this.isCellSurrounded(allCells, neighbourCellX, neighbourCellZ)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isCellSurrounded(MazeCell[][] allCells, int currentX, int currentZ) {
        int numberOfSidesOccupied = 0;
        for (Direction direction : Direction.getCardinals()) {
            int neighbourX = currentX + direction.x;
            int neighbourZ = currentZ + direction.z;
            if (this.isCellOutOfBounds(allCells, neighbourX, neighbourZ) || allCells[neighbourX][neighbourZ].rawState != 1) continue;
            ++numberOfSidesOccupied;
        }
        return numberOfSidesOccupied >= 4;
    }

    private boolean isCellOutOfBounds(MazeCell[][] allCells, int currentX, int currentZ) {
        return currentX < 0 || currentX >= allCells.length || currentZ < 0 || currentZ >= allCells[0].length;
    }
}

