/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.kappaexperience.emote;

import com.lordmau5.kappaexperience.emote.EmoteRegistry;
import com.lordmau5.kappaexperience.emote.IEmote;
import com.lordmau5.kappaexperience.util.ImageLoader;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;

public class Emote
implements IEmote,
Comparable<Emote> {
    private String channel;
    private String emoteName;
    private BufferedImage image;
    private int tex = -1;
    private String emoteUrl;
    private boolean downloading = false;

    public Emote(String emoteName, String channel, String path) {
        this.emoteName = emoteName;
        this.channel = channel;
        this.emoteUrl = path;
    }

    @Override
    public String getName() {
        return this.emoteName;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Emote: " + EnumChatFormatting.GREEN + EnumChatFormatting.ITALIC + this.getName());
        list.add("Channel: " + EnumChatFormatting.GREEN + EnumChatFormatting.ITALIC + this.getChannel());
        return list;
    }

    @Override
    public BufferedImage getImage() {
        if (this.image == null) {
            this.image = EmoteRegistry.getCachedEmote(this.emoteName);
            if (this.image == null && !this.downloading) {
                this.downloading = true;
                new Thread(){

                    @Override
                    public void run() {
                        super.run();
                        Emote.this.image = ImageLoader.loadImageFromURL(Emote.this.emoteUrl);
                        EmoteRegistry.cacheEmote(Emote.this.emoteName, Emote.this.image);
                        Emote.this.downloading = false;
                    }
                }.start();
            }
        }
        return this.image;
    }

    @Override
    public int getTex() {
        return this.tex;
    }

    @Override
    public void setTex(int tex) {
        this.tex = tex;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IEmote)) {
            return false;
        }
        IEmote oEmote = (IEmote)object;
        return oEmote.getName().equals(this.getName());
    }

    @Override
    public int compareTo(Emote o) {
        return this.getName().compareTo(o.getName());
    }
}

