/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.utilities;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public class Infodata {
    public String name;
    public Hashtable<String, String> fields = new Hashtable();
    public String[] lines;

    public Infodata(String n) {
        this.name = n;
    }

    public Infodata(String n, int lineCount) {
        this.name = n;
        this.lines = new String[lineCount];
    }

    public String field(String key, String dflt) {
        String n = key.toLowerCase();
        if (this.fields.containsKey(n)) {
            return this.fields.get(n);
        }
        return dflt;
    }

    public String field(String key) {
        return this.field(key, null);
    }

    public int value(String key) {
        return Integer.parseInt(this.field(key, null));
    }

    public void set(String key, String value) {
        this.fields.put(key.length() == 1 ? key : key.toLowerCase(), value);
    }

    public void set(String key, int value) {
        this.fields.put(key.length() == 1 ? key : key.toLowerCase(), "" + value);
    }

    public void write(Writer writer, int linebreakEvery) throws IOException {
        writer.write(this.name + " {\n");
        Enumeration<String> keys = this.fields.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.length() == 1) continue;
            writer.write("\t" + key + " = " + this.fields.get(key) + "\n");
        }
        writer.write("\n");
        int linesWritten = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            writer.write("\t" + this.lines[i] + "\n");
            if (linebreakEvery == 0 || ++linesWritten % linebreakEvery != 0) continue;
            writer.write("\n");
        }
        writer.write("\n");
        keys = this.fields.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.length() != 1) continue;
            writer.write("\t" + key + " = " + this.fields.get(key) + "\n");
        }
        writer.write("}");
    }
}

