/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.mfr.machines;

import cofh.lib.util.WeightedRandomItemStack;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.WeightedItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.util.WeightedRandom;
import powercrystals.minefactoryreloaded.MFRRegistry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mfr.SludgeBoiler")
@ModOnly(value={"MineFactoryReloaded"})
public class SludgeBoiler {
    @ZenMethod
    public static void addDrop(WeightedItemStack item) {
        MineTweakerAPI.apply(new AddDropAction(item));
    }

    @ZenMethod
    public static void removeDrop(IIngredient item) {
        if (MFRRegistry.getSludgeDrops() == null) {
            MineTweakerAPI.logWarning("Cannot remove drops from the sludge boiler");
        } else {
            MineTweakerAPI.apply(new RemoveDropAction(item));
        }
    }

    private static class RemoveDropAction
    implements IUndoableAction {
        private final IIngredient item;
        private final List<WeightedRandomItemStack> toRemove;

        private RemoveDropAction(IIngredient item) {
            this.item = item;
            this.toRemove = new ArrayList<WeightedRandomItemStack>();
            for (WeightedRandom.Item iStack : MFRRegistry.getSludgeDrops()) {
                WeightedRandomItemStack itemStack;
                if (!(iStack instanceof WeightedRandomItemStack) || !item.matches(MineTweakerMC.getIItemStack((itemStack = (WeightedRandomItemStack)iStack).getStack()))) continue;
                this.toRemove.add(itemStack);
            }
        }

        @Override
        public void apply() {
            for (WeightedRandomItemStack itemStack : this.toRemove) {
                MFRRegistry.getSludgeDrops().remove(itemStack);
            }
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            for (WeightedRandomItemStack item : this.toRemove) {
                MFRRegistry.getSludgeDrops().add(item);
            }
        }

        @Override
        public String describe() {
            return "Removing " + this.toRemove.size() + " sludge boiler drops for " + this.item;
        }

        @Override
        public String describeUndo() {
            return "Restoring " + this.toRemove.size() + " sludge boiler drops for " + this.item;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddDropAction
    implements IUndoableAction {
        private final WeightedRandomItemStack item;

        public AddDropAction(WeightedItemStack item) {
            this.item = new WeightedRandomItemStack(MineTweakerMC.getItemStack(item.getStack()), (int)item.getChance());
        }

        @Override
        public void apply() {
            MFRRegistry.getSludgeDrops().add(this.item);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            MFRRegistry.getSludgeDrops().remove(this.item);
        }

        @Override
        public String describe() {
            return "Adding sludge boiler drop " + this.item.getStack().func_82833_r();
        }

        @Override
        public String describeUndo() {
            return "Removing sludge boiler drop " + this.item.getStack().func_82833_r();
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }
}

