/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.handlers.PlayerTimers;
import moze_intel.projecte.utils.MathUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class SoulStone
extends RingToggle
implements IBauble,
IPedestalItem {
    private int healCooldown;

    public SoulStone() {
        super("soul_stone");
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K || par4 > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        super.func_77663_a(stack, world, entity, par4, par5);
        EntityPlayer player = (EntityPlayer)entity;
        if (stack.func_77960_j() != 0) {
            if (SoulStone.getEmc(stack) < 64.0 && !SoulStone.consumeFuel(player, stack, 64.0, false)) {
                stack.func_77964_b(0);
            } else {
                PlayerTimers.activateHeal(player);
                if (player.func_110143_aJ() < player.func_110138_aP() && PlayerTimers.canHeal(player)) {
                    world.func_72956_a((Entity)player, "projecte:item.peheal", 1.0f, 1.0f);
                    player.func_70691_i(2.0f);
                    SoulStone.removeEmc(stack, 64.0);
                }
            }
        }
    }

    @Override
    public void changeMode(EntityPlayer player, ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            if (!(SoulStone.getEmc(stack) < 64.0) || SoulStone.consumeFuel(player, stack, 64.0, false)) {
                stack.func_77964_b(1);
            }
        } else {
            stack.func_77964_b(0);
        }
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(World world, int x, int y, int z) {
        if (!world.field_72995_K && ProjectEConfig.soulPedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_147438_o(x, y, z);
            if (tile.getActivityCooldown() == 0) {
                List players = world.func_72872_a(EntityPlayerMP.class, tile.getEffectBounds());
                for (EntityPlayerMP player : players) {
                    if (!(player.func_110143_aJ() < player.func_110138_aP())) continue;
                    world.func_72956_a((Entity)player, "projecte:item.peheal", 1.0f, 1.0f);
                    player.func_70691_i(1.0f);
                }
                tile.setActivityCooldown(ProjectEConfig.soulPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.soulPedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.soul.pedestal1"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.soul.pedestal2"), MathUtils.tickToSecFormatted(ProjectEConfig.soulPedCooldown)));
        }
        return list;
    }
}

