/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import cpw.mods.fml.common.Loader;
import java.util.Locale;
import moze_intel.projecte.utils.ItemSearchHelperNEI;
import net.minecraft.item.ItemStack;

public abstract class ItemSearchHelper {
    public final String searchString;

    public static ItemSearchHelper create(String searchString) {
        if (Loader.isModLoaded((String)"NotEnoughItems")) {
            return new ItemSearchHelperNEI(searchString);
        }
        return new DefaultSearch(searchString);
    }

    public ItemSearchHelper(String searchString) {
        this.searchString = searchString;
    }

    public final boolean doesItemMatchFilter(ItemStack itemStack) {
        try {
            return this.doesItemMatchFilter_(itemStack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    protected abstract boolean doesItemMatchFilter_(ItemStack var1);

    private static class DefaultSearch
    extends ItemSearchHelper {
        public DefaultSearch(String searchString) {
            super(searchString);
        }

        @Override
        public boolean doesItemMatchFilter_(ItemStack stack) {
            String displayName;
            try {
                displayName = stack.func_82833_r().toLowerCase(Locale.ROOT);
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
            if (displayName == null) {
                return false;
            }
            return this.searchString.length() <= 0 || displayName.contains(this.searchString);
        }
    }
}

