/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.asm;

import ivorius.ivtoolkit.asm.IvClassTransformer;
import java.util.ArrayList;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public abstract class IvClassTransformerClass
extends IvClassTransformer {
    public ArrayList<String[]> registeredMethods = new ArrayList();

    public IvClassTransformerClass(Logger logger) {
        super(logger);
    }

    public void registerExpectedMethod(String methodID, String obfName, String signature) {
        this.registeredMethods.add(new String[]{obfName, signature, methodID});
    }

    @Override
    public boolean transform(String className, ClassNode classNode, boolean obf) {
        boolean[] sigs = new boolean[this.registeredMethods.size()];
        for (MethodNode m : classNode.methods) {
            for (int methodIndex = 0; methodIndex < this.registeredMethods.size(); ++methodIndex) {
                String[] methodInfo = this.registeredMethods.get(methodIndex);
                String srgName = IvClassTransformerClass.getSrgName(className, m);
                String srgSignature = IvClassTransformerClass.getSRGDescriptor(m.desc);
                if (!srgName.equals(methodInfo[0]) || !srgSignature.equals(methodInfo[1]) || !this.transformMethod(className, methodInfo[2], m, obf)) continue;
                sigs[methodIndex] = true;
            }
        }
        boolean didChange = false;
        for (int methodIndex = 0; methodIndex < this.registeredMethods.size(); ++methodIndex) {
            if (!sigs[methodIndex]) {
                String[] methodInfo = this.registeredMethods.get(methodIndex);
                this.logger.error("Could not transform expected method in class \"" + className + "\" (Obf: " + obf + "): " + methodInfo[0] + " - " + methodInfo[1] + " - " + methodInfo[2]);
                continue;
            }
            didChange = true;
        }
        return didChange;
    }

    public abstract boolean transformMethod(String var1, String var2, MethodNode var3, boolean var4);
}

