/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.math;

import ivorius.ivtoolkit.blocks.BlockCoord;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AxisAlignedTransform2D {
    public static final AxisAlignedTransform2D R0 = new AxisAlignedTransform2D(0, false);
    public static final AxisAlignedTransform2D R1 = new AxisAlignedTransform2D(1, false);
    public static final AxisAlignedTransform2D R2 = new AxisAlignedTransform2D(2, false);
    public static final AxisAlignedTransform2D R3 = new AxisAlignedTransform2D(3, false);
    public static final AxisAlignedTransform2D R0_F = new AxisAlignedTransform2D(0, true);
    public static final AxisAlignedTransform2D R1_F = new AxisAlignedTransform2D(1, true);
    public static final AxisAlignedTransform2D R2_F = new AxisAlignedTransform2D(2, true);
    public static final AxisAlignedTransform2D R3_F = new AxisAlignedTransform2D(3, true);
    public static final AxisAlignedTransform2D ORIGINAL = R0;
    private final int rotation;
    private final boolean mirrorX;

    @Deprecated
    public AxisAlignedTransform2D(int rotation, boolean mirrorX) {
        this.rotation = (rotation % 4 + 4) % 4;
        this.mirrorX = mirrorX;
    }

    @Deprecated
    public static AxisAlignedTransform2D transform(int rotationClockwise, boolean flipX) {
        return AxisAlignedTransform2D.from(rotationClockwise, flipX);
    }

    public static AxisAlignedTransform2D from(int rotationClockwise, boolean flipX) {
        switch ((rotationClockwise % 4 + 4) % 4) {
            case 0: {
                return flipX ? R0_F : R0;
            }
            case 1: {
                return flipX ? R1_F : R1;
            }
            case 2: {
                return flipX ? R2_F : R2;
            }
            case 3: {
                return flipX ? R3_F : R3;
            }
        }
        throw new InternalError();
    }

    public static AxisAlignedTransform2D transform(AxisAlignedTransform2D original, int rotationClockwise, boolean flipX) {
        return flipX ? original.rotateClockwise(rotationClockwise).flipX() : original.rotateClockwise(rotationClockwise);
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isMirrorX() {
        return this.mirrorX;
    }

    public AxisAlignedTransform2D rotateClockwise(int steps) {
        return AxisAlignedTransform2D.from(this.rotation + steps, this.mirrorX);
    }

    public AxisAlignedTransform2D rotateClockwise() {
        return AxisAlignedTransform2D.from(this.rotation + 1, this.mirrorX);
    }

    public AxisAlignedTransform2D rotateCounterClockwise(int steps) {
        return AxisAlignedTransform2D.from(this.rotation - steps, this.mirrorX);
    }

    public AxisAlignedTransform2D rotateCounterClockwise() {
        return AxisAlignedTransform2D.from(this.rotation - 1, this.mirrorX);
    }

    public AxisAlignedTransform2D flipX() {
        return AxisAlignedTransform2D.from(this.rotation, !this.mirrorX);
    }

    public AxisAlignedTransform2D flipZ() {
        return AxisAlignedTransform2D.from(this.rotation + 2, !this.mirrorX);
    }

    public boolean resultSwitchesXZ() {
        return this.rotation == 1 || this.rotation == 3;
    }

    public boolean resultMirrorsFormerX() {
        return this.mirrorX ^ (this.rotation == 2 || this.rotation == 3);
    }

    public boolean resultMirrorsFormerZ() {
        return this.rotation == 1 || this.rotation == 2;
    }

    public BlockCoord apply(BlockCoord position, int[] size) {
        int positionX = this.mirrorX ? size[0] - 1 - position.x : position.x;
        switch (this.rotation) {
            case 0: {
                return new BlockCoord(positionX, position.y, position.z);
            }
            case 1: {
                return new BlockCoord(size[2] - 1 - position.z, position.y, positionX);
            }
            case 2: {
                return new BlockCoord(size[0] - 1 - positionX, position.y, size[2] - 1 - position.z);
            }
            case 3: {
                return new BlockCoord(position.z, position.y, size[0] - 1 - positionX);
            }
        }
        throw new InternalError();
    }

    public ChunkCoordinates apply(ChunkCoordinates position, int[] size) {
        int positionX = this.mirrorX ? size[0] - 1 - position.field_71574_a : position.field_71574_a;
        switch (this.rotation) {
            case 0: {
                return new ChunkCoordinates(positionX, position.field_71572_b, position.field_71573_c);
            }
            case 1: {
                return new ChunkCoordinates(size[2] - 1 - position.field_71573_c, position.field_71572_b, positionX);
            }
            case 2: {
                return new ChunkCoordinates(size[0] - 1 - positionX, position.field_71572_b, size[2] - 1 - position.field_71573_c);
            }
            case 3: {
                return new ChunkCoordinates(position.field_71573_c, position.field_71572_b, size[0] - 1 - positionX);
            }
        }
        throw new InternalError();
    }

    public double[] apply(double[] position, int[] size) {
        double positionX = this.mirrorX ? (double)(size[0] - 1) - position[0] : position[0];
        switch (this.rotation) {
            case 0: {
                return new double[]{positionX, position[1], position[2]};
            }
            case 1: {
                return new double[]{(double)(size[2] - 1) - position[2], position[1], positionX};
            }
            case 2: {
                return new double[]{(double)(size[0] - 1) - positionX, position[1], (double)(size[2] - 1) - position[2]};
            }
            case 3: {
                return new double[]{position[2], position[1], (double)(size[0] - 1) - positionX};
            }
        }
        throw new InternalError();
    }

    public float[] apply(float[] position, int[] size) {
        float positionX = this.mirrorX ? (float)(size[0] - 1) - position[0] : position[0];
        switch (this.rotation) {
            case 0: {
                return new float[]{positionX, position[1], position[2]};
            }
            case 1: {
                return new float[]{(float)(size[2] - 1) - position[2], position[1], positionX};
            }
            case 2: {
                return new float[]{(float)(size[0] - 1) - positionX, position[1], (float)(size[2] - 1) - position[2]};
            }
            case 3: {
                return new float[]{position[2], position[1], (float)(size[0] - 1) - positionX};
            }
        }
        throw new InternalError();
    }

    public int[] apply(int[] position, int[] size) {
        int positionX = this.mirrorX ? size[0] - 1 - position[0] : position[0];
        switch (this.rotation) {
            case 0: {
                return new int[]{positionX, position[1], position[2]};
            }
            case 1: {
                return new int[]{size[2] - 1 - position[2], position[1], positionX};
            }
            case 2: {
                return new int[]{size[0] - 1 - positionX, position[1], size[2] - 1 - position[2]};
            }
            case 3: {
                return new int[]{position[2], position[1], size[0] - 1 - positionX};
            }
        }
        throw new InternalError();
    }

    public void rotateBlock(World world, BlockCoord coord, Block block) {
        for (int i = 0; i < this.rotation; ++i) {
            block.rotateBlock(world, coord.x, coord.y, coord.z, ForgeDirection.UP);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AxisAlignedTransform2D that = (AxisAlignedTransform2D)o;
        if (this.rotation != that.rotation) {
            return false;
        }
        return this.mirrorX == that.mirrorX;
    }

    public int hashCode() {
        int result = this.rotation;
        result = 31 * result + (this.mirrorX ? 1 : 0);
        return result;
    }

    public String toString() {
        return "AxisAlignedTransform2D{rotation=" + this.rotation + ", mirrorX=" + this.mirrorX + '}';
    }
}

