/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import com.google.common.collect.ImmutableSet;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MazeRoomConnection;
import ivorius.ivtoolkit.tools.Ranges;
import java.util.Set;

public class MazeRooms {
    public static MazeRoom rotated(MazeRoom room, AxisAlignedTransform2D transform, int[] size) {
        if (room.getDimensions() < 3) {
            throw new IllegalArgumentException();
        }
        int[] roomPosition = room.getCoordinates();
        int[] transformedRoom = transform.apply(roomPosition, size);
        roomPosition[0] = transformedRoom[0];
        roomPosition[1] = transformedRoom[1];
        roomPosition[2] = transformedRoom[2];
        return new MazeRoom(roomPosition);
    }

    public static Set<MazeRoomConnection> neighbors(final MazeRoom room, TIntSet dimensions) {
        final ImmutableSet.Builder set = ImmutableSet.builder();
        dimensions.forEach(new TIntProcedure(){

            public boolean execute(int value) {
                set.add((Object)new MazeRoomConnection(room, room.addInDimension(value, 1)));
                set.add((Object)new MazeRoomConnection(room, room.addInDimension(value, -1)));
                return true;
            }
        });
        return set.build();
    }

    public static Set<MazeRoomConnection> neighbors(MazeRoom room) {
        return MazeRooms.neighbors(room, (TIntSet)new TIntHashSet(Ranges.to(room.getDimensions())));
    }
}

