/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import com.google.common.base.Function;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTCompoundObjects {
    public static <T extends NBTCompoundObject> Function<NBTTagCompound, T> readFunction(final Class<T> tClass) {
        return new Function<NBTTagCompound, T>(){

            @Nullable
            public T apply(NBTTagCompound input) {
                return NBTCompoundObjects.read(input, tClass);
            }
        };
    }

    public static Function<? extends NBTCompoundObject, NBTTagCompound> writeFunction() {
        return new Function<NBTCompoundObject, NBTTagCompound>(){

            @Nullable
            public NBTTagCompound apply(@Nullable NBTCompoundObject input) {
                return NBTCompoundObjects.write(input);
            }
        };
    }

    public static void writeListTo(NBTTagCompound compound, String key, Iterable<? extends NBTCompoundObject> objects) {
        compound.func_74782_a(key, (NBTBase)NBTCompoundObjects.writeList(objects));
    }

    public static <T extends NBTCompoundObject> List<T> readListFrom(NBTTagCompound compound, String key, Class<T> tClass) {
        return NBTCompoundObjects.readList(compound.func_150295_c(key, 10), tClass);
    }

    public static NBTTagList writeList(Iterable<? extends NBTCompoundObject> objects) {
        NBTTagList tagList = new NBTTagList();
        for (NBTCompoundObject nBTCompoundObject : objects) {
            NBTTagCompound compound = new NBTTagCompound();
            nBTCompoundObject.writeToNBT(compound);
            tagList.func_74742_a((NBTBase)compound);
        }
        return tagList;
    }

    public static <T extends NBTCompoundObject> List<T> readList(NBTTagList list, Class<T> tClass) {
        ArrayList<T> rList = new ArrayList<T>(list.func_74745_c());
        for (int i = 0; i < list.func_74745_c(); ++i) {
            rList.add(NBTCompoundObjects.read(list.func_150305_b(i), tClass));
        }
        return rList;
    }

    public static <T extends NBTCompoundObject> T read(NBTTagCompound compound, Class<T> tClass) {
        try {
            NBTCompoundObject t = (NBTCompoundObject)tClass.newInstance();
            t.readFromNBT(compound);
            return (T)t;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NBTTagCompound write(NBTCompoundObject compoundObject) {
        NBTTagCompound compound = new NBTTagCompound();
        compoundObject.writeToNBT(compound);
        return compound;
    }
}

