/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class Pairs {
    public static <T> Iterable<T> both(Iterable<? extends Pair<T, T>> set) {
        return Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform(set, Pairs.leftFunction()), (Iterable)Iterables.transform(set, Pairs.rightFunction())));
    }

    public static <T> Function<Pair<T, T>, T> rightFunction() {
        return new Function<Pair<T, T>, T>(){

            @Nullable
            public T apply(@Nullable Pair<T, T> input) {
                return input.getRight();
            }
        };
    }

    public static <T> Function<Pair<T, T>, T> leftFunction() {
        return new Function<Pair<T, T>, T>(){

            @Nullable
            public T apply(@Nullable Pair<T, T> input) {
                return input.getLeft();
            }
        };
    }

    public static <L, R> Iterable<Pair<L, R>> pairLeft(final L left, Iterable<R> right) {
        return Iterables.transform(right, (Function)new Function<R, Pair<L, R>>(){

            @Nullable
            public Pair<L, R> apply(R input) {
                return Pair.of((Object)left, input);
            }
        });
    }

    public static <L, R> Iterable<Pair<L, R>> pairRight(Iterable<L> left, final R right) {
        return Iterables.transform(left, (Function)new Function<L, Pair<L, R>>(){

            @Nullable
            public Pair<L, R> apply(L input) {
                return Pair.of(input, (Object)right);
            }
        });
    }

    public static <L, R> Iterable<Pair<L, R>> of(final Iterable<L> left, final Iterable<R> right) {
        return new FluentIterable<Pair<L, R>>(){

            public Iterator<Pair<L, R>> iterator() {
                return new PairIterator(left.iterator(), right.iterator());
            }
        };
    }

    public static <L, R> List<Pair<L, R>> of(List<L> left, List<R> right) {
        return new PairList<L, R>(left, right);
    }

    protected static class PairList<L, R>
    extends AbstractList<Pair<L, R>> {
        protected List<L> left;
        protected List<R> right;

        public PairList(List<L> left, List<R> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public Pair<L, R> get(int index) {
            return Pair.of(this.left.get(index), this.right.get(index));
        }

        @Override
        public int size() {
            return Math.min(this.left.size(), this.right.size());
        }

        @Override
        public Iterator<Pair<L, R>> iterator() {
            return new PairIterator<L, R>(this.left.listIterator(), this.right.listIterator());
        }

        @Override
        public boolean remove(Object o) {
            return this.left.remove(((Pair)o).getLeft()) && this.right.remove(((Pair)o).getRight());
        }
    }

    protected static class PairIterator<L, R>
    implements Iterator<Pair<L, R>> {
        protected Iterator<L> left;
        protected Iterator<R> right;

        public PairIterator(Iterator<L> left, Iterator<R> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean hasNext() {
            return this.left.hasNext() && this.right.hasNext();
        }

        @Override
        public Pair<L, R> next() {
            return Pair.of(this.left.next(), this.right.next());
        }

        @Override
        public void remove() {
            this.left.remove();
            this.right.remove();
        }
    }
}

