/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.common.tileentities.TileParticleGenerator;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderTileParticleGen
extends TileEntitySpecialRenderer {
    private final ResourceLocation texture = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/models/ParticleGenTextureSheet.png");
    private final ResourceLocation beamTexture = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/models/stabilizer_beam.png");
    private static final ResourceLocation modelTexture = new ResourceLocation("DraconicEvolution".toLowerCase(), "textures/models/stabilizer_sphere.png");
    private IModelCustom stabilizerSphereModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("DraconicEvolution".toLowerCase(), "models/stabilizer_sphere.obj"));
    private float pxl = 0.015625f;

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        TileParticleGenerator tileEntityGen = (TileParticleGenerator)tileEntity;
        this.renderBlock(tileEntityGen, f);
        GL11.glPopMatrix();
    }

    public void renderBlock(TileParticleGenerator tl, float f3) {
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean inverted = tl.inverted;
        boolean stabilizerMode = tl.stabalizerMode;
        GL11.glPushMatrix();
        this.func_147499_a(this.texture);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        tessellator.func_78370_a(255, 255, 255, 255);
        float f = 0.4f;
        this.drawCornerCube(tessellator, f, f, f, 1.0f - f, inverted, stabilizerMode);
        this.drawCornerCube(tessellator, f, -f, f, 1.0f - f, inverted, stabilizerMode);
        this.drawCornerCube(tessellator, -f, f, -f, 1.0f - f, inverted, stabilizerMode);
        this.drawCornerCube(tessellator, -f, -f, -f, 1.0f - f, inverted, stabilizerMode);
        this.drawCornerCube(tessellator, -f, f, f, 1.0f - f, inverted, stabilizerMode);
        this.drawCornerCube(tessellator, f, f, -f, 1.0f - f, inverted, stabilizerMode);
        this.drawCornerCube(tessellator, f, -f, -f, 1.0f - f, inverted, stabilizerMode);
        this.drawCornerCube(tessellator, -f, -f, f, 1.0f - f, inverted, stabilizerMode);
        f = 0.45f;
        float f2 = 0.4f;
        this.drawBeamX(tessellator, 0.0f, f2, f2, 1.0f - f);
        this.drawBeamX(tessellator, 0.0f, -f2, f2, 1.0f - f);
        this.drawBeamX(tessellator, 0.0f, f2, -f2, 1.0f - f);
        this.drawBeamX(tessellator, 0.0f, -f2, -f2, 1.0f - f);
        this.drawBeamY(tessellator, f2, 0.0f, f2, 1.0f - f);
        this.drawBeamY(tessellator, -f2, 0.0f, f2, 1.0f - f);
        this.drawBeamY(tessellator, f2, 0.0f, -f2, 1.0f - f);
        this.drawBeamY(tessellator, -f2, 0.0f, -f2, 1.0f - f);
        this.drawBeamZ(tessellator, f2, f2, 0.0f, 1.0f - f);
        this.drawBeamZ(tessellator, -f2, f2, 0.0f, 1.0f - f);
        this.drawBeamZ(tessellator, f2, -f2, 0.0f, 1.0f - f);
        this.drawBeamZ(tessellator, -f2, -f2, 0.0f, 1.0f - f);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        if (stabilizerMode) {
            this.drawEnergyBeam(tessellator, tl, f3);
        }
        if (tl.beam_enabled) {
            this.preRenderBeam(tessellator, tl, f3);
        }
    }

    private void drawEnergyBeam(Tessellator tess, TileParticleGenerator gen, float f) {
        TileEnergyStorageCore master = gen.getMaster();
        if (master == null) {
            return;
        }
        float length = 0.0f;
        GL11.glPushMatrix();
        if (master.field_145851_c > gen.field_145851_c) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)-1.0, (double)0.5, (double)0.0);
            length = (float)(master.field_145851_c - gen.field_145851_c) - 0.2f;
        } else if (master.field_145851_c < gen.field_145851_c) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
            length = (float)(gen.field_145851_c - master.field_145851_c) - 0.2f;
        } else if (master.field_145849_e > gen.field_145849_e) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)0.5, (double)-1.0);
            length = (float)(master.field_145849_e - gen.field_145849_e) - 0.2f;
        } else if (master.field_145849_e < gen.field_145849_e) {
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
            length = (float)(gen.field_145849_e - master.field_145849_e) - 0.2f;
        }
        this.renderStabilizerSphere(gen);
        this.renderEnergyBeam(tess, gen, length, f);
        GL11.glPopMatrix();
    }

    public void renderStabilizerSphere(TileParticleGenerator tile) {
        float blue;
        float green;
        float red;
        GL11.glPushMatrix();
        GL11.glColor4f((float)0.0f, (float)2.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        if (!tile.stabalizerMode) {
            red = (float)tile.beam_red / 255.0f;
            green = (float)tile.beam_green / 255.0f;
            blue = (float)tile.beam_blue / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            GL11.glScalef((float)tile.beam_scale, (float)tile.beam_scale, (float)tile.beam_scale);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)200.0f, (float)200.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(modelTexture);
        GL11.glRotatef((float)tile.rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        this.stabilizerSphereModel.renderAll();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)200.0f, (float)200.0f);
        GL11.glRotatef((float)(tile.rotation * 2.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        if (!tile.stabalizerMode) {
            red = (float)tile.beam_red / 255.0f;
            green = (float)tile.beam_green / 255.0f;
            blue = (float)tile.beam_blue / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)0.5f);
        }
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glScalef((float)1.3f, (float)1.3f, (float)1.3f);
        this.stabilizerSphereModel.renderAll();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    private void renderEnergyBeam(Tessellator tess, TileParticleGenerator tile, float length, float f) {
        boolean x = false;
        boolean y = false;
        boolean z = false;
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)516, (float)0.1f);
        this.func_147499_a(this.beamTexture);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        float time = tile.rotation + f;
        float upMot = -time * 0.2f - (float)MathHelper.func_76141_d((float)(-time * 0.1f));
        boolean scaleMult = true;
        double rotation = (double)time * 0.025 * (1.0 - (double)(scaleMult & true) * 2.5);
        tess.func_78382_b();
        tess.func_78370_a(255, 255, 255, 32);
        double scale = (double)scaleMult * 0.2;
        double d7 = 0.5 + Math.cos(rotation + 2.356194490192345) * scale;
        double d9 = 0.5 + Math.sin(rotation + 2.356194490192345) * scale;
        double d11 = 0.5 + Math.cos(rotation + 0.7853981633974483) * scale;
        double d13 = 0.5 + Math.sin(rotation + 0.7853981633974483) * scale;
        double d15 = 0.5 + Math.cos(rotation + 3.9269908169872414) * scale;
        double d17 = 0.5 + Math.sin(rotation + 3.9269908169872414) * scale;
        double d19 = 0.5 + Math.cos(rotation + 5.497787143782138) * scale;
        double d21 = 0.5 + Math.sin(rotation + 5.497787143782138) * scale;
        double height = length;
        double texXMin = 0.0;
        double texXMax = 1.0;
        double d28 = -1.0f + upMot;
        double texHeight = (double)length * (0.5 / scale) + d28;
        tess.func_78374_a((double)x + d7, (double)y + height, (double)z + d9, texXMax, texHeight);
        tess.func_78374_a((double)x + d7, (double)y, (double)z + d9, texXMax, d28);
        tess.func_78374_a((double)x + d11, (double)y, (double)z + d13, texXMin, d28);
        tess.func_78374_a((double)x + d11, (double)y + height, (double)z + d13, texXMin, texHeight);
        tess.func_78374_a((double)x + d19, (double)y + height, (double)z + d21, texXMax, texHeight);
        tess.func_78374_a((double)x + d19, (double)y, (double)z + d21, texXMax, d28);
        tess.func_78374_a((double)x + d15, (double)y, (double)z + d17, texXMin, d28);
        tess.func_78374_a((double)x + d15, (double)y + height, (double)z + d17, texXMin, texHeight);
        tess.func_78374_a((double)x + d11, (double)y + height, (double)z + d13, texXMax, texHeight);
        tess.func_78374_a((double)x + d11, (double)y, (double)z + d13, texXMax, d28);
        tess.func_78374_a((double)x + d19, (double)y, (double)z + d21, texXMin, d28);
        tess.func_78374_a((double)x + d19, (double)y + height, (double)z + d21, texXMin, texHeight);
        tess.func_78374_a((double)x + d15, (double)y + height, (double)z + d17, texXMax, texHeight);
        tess.func_78374_a((double)x + d15, (double)y, (double)z + d17, texXMax, d28);
        tess.func_78374_a((double)x + d7, (double)y, (double)z + d9, texXMin, d28);
        tess.func_78374_a((double)x + d7, (double)y + height, (double)z + d9, texXMin, texHeight);
        d7 = 0.5 + Math.cos((rotation += (double)0.77f) + 2.356194490192345) * scale;
        d9 = 0.5 + Math.sin(rotation + 2.356194490192345) * scale;
        d11 = 0.5 + Math.cos(rotation + 0.7853981633974483) * scale;
        d13 = 0.5 + Math.sin(rotation + 0.7853981633974483) * scale;
        d15 = 0.5 + Math.cos(rotation + 3.9269908169872414) * scale;
        d17 = 0.5 + Math.sin(rotation + 3.9269908169872414) * scale;
        d19 = 0.5 + Math.cos(rotation + 5.497787143782138) * scale;
        d21 = 0.5 + Math.sin(rotation + 5.497787143782138) * scale;
        d28 = -1.0f + upMot * 1.0f;
        texHeight = (double)length * (0.5 / scale) + d28;
        tess.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        tess.func_78374_a((double)x + d7, (double)y + height, (double)z + d9, texXMax, texHeight);
        tess.func_78374_a((double)x + d7, (double)y, (double)z + d9, texXMax, d28);
        tess.func_78374_a((double)x + d11, (double)y, (double)z + d13, texXMin, d28);
        tess.func_78374_a((double)x + d11, (double)y + height, (double)z + d13, texXMin, texHeight);
        tess.func_78374_a((double)x + d19, (double)y + height, (double)z + d21, texXMax, texHeight);
        tess.func_78374_a((double)x + d19, (double)y, (double)z + d21, texXMax, d28);
        tess.func_78374_a((double)x + d15, (double)y, (double)z + d17, texXMin, d28);
        tess.func_78374_a((double)x + d15, (double)y + height, (double)z + d17, texXMin, texHeight);
        tess.func_78374_a((double)x + d11, (double)y + height, (double)z + d13, texXMax, texHeight);
        tess.func_78374_a((double)x + d11, (double)y, (double)z + d13, texXMax, d28);
        tess.func_78374_a((double)x + d19, (double)y, (double)z + d21, texXMin, d28);
        tess.func_78374_a((double)x + d19, (double)y + height, (double)z + d21, texXMin, texHeight);
        tess.func_78374_a((double)x + d15, (double)y + height, (double)z + d17, texXMax, texHeight);
        tess.func_78374_a((double)x + d15, (double)y, (double)z + d17, texXMax, d28);
        tess.func_78374_a((double)x + d7, (double)y, (double)z + d9, texXMin, d28);
        tess.func_78374_a((double)x + d7, (double)y + height, (double)z + d9, texXMin, texHeight);
        tess.func_78381_a();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.4, (double)0.0);
        length -= 0.5f;
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDepthMask((boolean)false);
        tess.func_78382_b();
        tess.func_78370_a(255, 255, 255, 32);
        double d30 = 0.2;
        double d4 = 0.2;
        double d6 = 0.8;
        double d8 = 0.2;
        double d10 = 0.2;
        double d12 = 0.8;
        double d14 = 0.8;
        double d16 = 0.8;
        double d18 = length;
        double d20 = 0.0;
        double d22 = 1.0;
        double d24 = -1.0f + upMot;
        double d26 = (double)length + d24;
        tess.func_78374_a((double)x + d30, (double)y + d18, (double)z + d4, d22, d26);
        tess.func_78374_a((double)x + d30, (double)y, (double)z + d4, d22, d24);
        tess.func_78374_a((double)x + d6, (double)y, (double)z + d8, d20, d24);
        tess.func_78374_a((double)x + d6, (double)y + d18, (double)z + d8, d20, d26);
        tess.func_78374_a((double)x + d14, (double)y + d18, (double)z + d16, d22, d26);
        tess.func_78374_a((double)x + d14, (double)y, (double)z + d16, d22, d24);
        tess.func_78374_a((double)x + d10, (double)y, (double)z + d12, d20, d24);
        tess.func_78374_a((double)x + d10, (double)y + d18, (double)z + d12, d20, d26);
        tess.func_78374_a((double)x + d6, (double)y + d18, (double)z + d8, d22, d26);
        tess.func_78374_a((double)x + d6, (double)y, (double)z + d8, d22, d24);
        tess.func_78374_a((double)x + d14, (double)y, (double)z + d16, d20, d24);
        tess.func_78374_a((double)x + d14, (double)y + d18, (double)z + d16, d20, d26);
        tess.func_78374_a((double)x + d10, (double)y + d18, (double)z + d12, d22, d26);
        tess.func_78374_a((double)x + d10, (double)y, (double)z + d12, d22, d24);
        tess.func_78374_a((double)x + d30, (double)y, (double)z + d4, d20, d24);
        tess.func_78374_a((double)x + d30, (double)y + d18, (double)z + d4, d20, d26);
        tess.func_78381_a();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void drawCornerCube(Tessellator tess, float x, float y, float z, float FP, boolean inverted, boolean stabalizerMode) {
        float srcXMin = inverted ? 38.0f * this.pxl : 32.0f * this.pxl;
        float srcYMin = 0.0f;
        float srcXMax = inverted ? 44.0f * this.pxl : 38.0f * this.pxl;
        float srcYMax = 6.0f * this.pxl;
        float FN = 1.0f - FP;
        if (stabalizerMode) {
            srcXMin = 44.0f * this.pxl;
            srcXMax = 50.0f * this.pxl;
        }
        tess.func_78374_a((double)(FP + x), (double)(FN + y), (double)(FN + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FP + y), (double)(FN + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FP + y), (double)(FP + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FP + x), (double)(FN + y), (double)(FP + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FN + y), (double)(FP + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)(FP + y), (double)(FP + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)(FP + y), (double)(FN + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FN + y), (double)(FN + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FP + y), (double)(FN + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)(FP + y), (double)(FP + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FP + y), (double)(FP + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FP + x), (double)(FP + y), (double)(FN + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FN + y), (double)(FN + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FN + y), (double)(FN + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FN + y), (double)(FP + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FN + y), (double)(FP + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FP + x), (double)(FN + y), (double)(FP + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FP + y), (double)(FP + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)(FP + y), (double)(FP + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FN + y), (double)(FP + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FN + y), (double)(FN + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)(FP + y), (double)(FN + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FP + y), (double)(FN + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FP + x), (double)(FN + y), (double)(FN + z), (double)srcXMin, (double)srcYMax);
    }

    private void drawBeamX(Tessellator tess, float x, float y, float z, float FP) {
        float srcXMin = 0.0f;
        float srcYMin = 0.0f;
        float srcXMax = 32.0f * this.pxl;
        float srcYMax = 4.0f * this.pxl;
        float FN = 1.0f - FP;
        float XX = 0.9f;
        float XM = 0.1f;
        tess.func_78374_a((double)XM, (double)(FP + y), (double)(FN + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)XM, (double)(FP + y), (double)(FP + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)XX, (double)(FP + y), (double)(FP + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)XX, (double)(FP + y), (double)(FN + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)XM, (double)(FN + y), (double)(FN + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)XX, (double)(FN + y), (double)(FN + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)XX, (double)(FN + y), (double)(FP + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)XM, (double)(FN + y), (double)(FP + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)XX, (double)(FN + y), (double)(FP + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)XX, (double)(FP + y), (double)(FP + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)XM, (double)(FP + y), (double)(FP + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)XM, (double)(FN + y), (double)(FP + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)XM, (double)(FN + y), (double)(FN + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)XM, (double)(FP + y), (double)(FN + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)XX, (double)(FP + y), (double)(FN + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)XX, (double)(FN + y), (double)(FN + z), (double)srcXMax, (double)srcYMax);
    }

    private void drawBeamY(Tessellator tess, float x, float y, float z, float FP) {
        float srcXMin = 0.0f;
        float srcYMin = 0.0f;
        float srcXMax = 32.0f * this.pxl;
        float srcYMax = 4.0f * this.pxl;
        float FN = 1.0f - FP;
        float XX = 0.9f;
        float XM = 0.1f;
        tess.func_78374_a((double)(FP + x), (double)XM, (double)(FN + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)XX, (double)(FN + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)XX, (double)(FP + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FP + x), (double)XM, (double)(FP + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)XM, (double)(FP + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)XX, (double)(FP + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)XX, (double)(FN + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)XM, (double)(FN + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FP + x), (double)XM, (double)(FP + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)XX, (double)(FP + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)XX, (double)(FP + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)XM, (double)(FP + z), (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)XM, (double)(FN + z), (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)XX, (double)(FN + z), (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)XX, (double)(FN + z), (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FP + x), (double)XM, (double)(FN + z), (double)srcXMin, (double)srcYMax);
    }

    private void drawBeamZ(Tessellator tess, float x, float y, float z, float FP) {
        float srcXMin = 0.0f;
        float srcYMin = 0.0f;
        float srcXMax = 32.0f * this.pxl;
        float srcYMax = 4.0f * this.pxl;
        float FN = 1.0f - FP;
        float XX = 0.9f;
        float XM = 0.1f;
        tess.func_78374_a((double)(FP + x), (double)(FN + y), (double)XM, (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FP + x), (double)(FP + y), (double)XM, (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FP + y), (double)XX, (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FN + y), (double)XX, (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FN + y), (double)XX, (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FP + y), (double)XX, (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)(FP + y), (double)XM, (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)(FN + y), (double)XM, (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FP + y), (double)XM, (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)(FP + y), (double)XX, (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FP + y), (double)XX, (double)srcXMax, (double)srcYMax);
        tess.func_78374_a((double)(FP + x), (double)(FP + y), (double)XM, (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FN + x), (double)(FN + y), (double)XM, (double)srcXMin, (double)srcYMax);
        tess.func_78374_a((double)(FP + x), (double)(FN + y), (double)XM, (double)srcXMin, (double)srcYMin);
        tess.func_78374_a((double)(FP + x), (double)(FN + y), (double)XX, (double)srcXMax, (double)srcYMin);
        tess.func_78374_a((double)(FN + x), (double)(FN + y), (double)XX, (double)srcXMax, (double)srcYMax);
    }

    private void preRenderBeam(Tessellator tess, TileParticleGenerator gen, float f) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.5, (double)0.5);
        GL11.glRotatef((float)(90.0f + gen.beam_pitch), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.5);
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
        GL11.glRotatef((float)gen.beam_yaw, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslated((double)-0.5, (double)0.0, (double)0.0);
        this.renderBeam(tess, gen, f);
        GL11.glPopMatrix();
        if (gen.render_core) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
            this.renderStabilizerSphere(gen);
            GL11.glPopMatrix();
        }
    }

    private void renderBeam(Tessellator tess, TileParticleGenerator tile, float f) {
        boolean x = false;
        boolean y = false;
        boolean z = false;
        double length = tile.beam_length;
        float red = (float)tile.beam_red / 255.0f;
        float green = (float)tile.beam_green / 255.0f;
        float blue = (float)tile.beam_blue / 255.0f;
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)516, (float)0.1f);
        this.func_147499_a(this.beamTexture);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        float time = tile.rotation + f;
        float upMot = -time * 0.2f - (float)MathHelper.func_76141_d((float)(-time * 0.1f));
        float rotValue = tile.beam_rotation * (tile.rotation + f * 0.5f);
        double rotation = rotValue;
        tess.func_78382_b();
        tess.func_78380_c(200);
        tess.func_78370_a(tile.beam_red, tile.beam_green, tile.beam_blue, 32);
        double scale = (double)tile.beam_scale * 0.2;
        double d7 = 0.5 + Math.cos(rotation + 2.356194490192345) * scale;
        double d9 = 0.5 + Math.sin(rotation + 2.356194490192345) * scale;
        double d11 = 0.5 + Math.cos(rotation + 0.7853981633974483) * scale;
        double d13 = 0.5 + Math.sin(rotation + 0.7853981633974483) * scale;
        double d15 = 0.5 + Math.cos(rotation + 3.9269908169872414) * scale;
        double d17 = 0.5 + Math.sin(rotation + 3.9269908169872414) * scale;
        double d19 = 0.5 + Math.cos(rotation + 5.497787143782138) * scale;
        double d21 = 0.5 + Math.sin(rotation + 5.497787143782138) * scale;
        double height = length;
        double texXMin = 0.0;
        double texXMax = 1.0;
        double d28 = -1.0f + upMot;
        double texHeight = length * (0.5 / scale) + d28;
        tess.func_78374_a((double)x + d7, (double)y + height, (double)z + d9, texXMax, texHeight);
        tess.func_78374_a((double)x + d7, (double)y, (double)z + d9, texXMax, d28);
        tess.func_78374_a((double)x + d11, (double)y, (double)z + d13, texXMin, d28);
        tess.func_78374_a((double)x + d11, (double)y + height, (double)z + d13, texXMin, texHeight);
        tess.func_78374_a((double)x + d19, (double)y + height, (double)z + d21, texXMax, texHeight);
        tess.func_78374_a((double)x + d19, (double)y, (double)z + d21, texXMax, d28);
        tess.func_78374_a((double)x + d15, (double)y, (double)z + d17, texXMin, d28);
        tess.func_78374_a((double)x + d15, (double)y + height, (double)z + d17, texXMin, texHeight);
        tess.func_78374_a((double)x + d11, (double)y + height, (double)z + d13, texXMax, texHeight);
        tess.func_78374_a((double)x + d11, (double)y, (double)z + d13, texXMax, d28);
        tess.func_78374_a((double)x + d19, (double)y, (double)z + d21, texXMin, d28);
        tess.func_78374_a((double)x + d19, (double)y + height, (double)z + d21, texXMin, texHeight);
        tess.func_78374_a((double)x + d15, (double)y + height, (double)z + d17, texXMax, texHeight);
        tess.func_78374_a((double)x + d15, (double)y, (double)z + d17, texXMax, d28);
        tess.func_78374_a((double)x + d7, (double)y, (double)z + d9, texXMin, d28);
        tess.func_78374_a((double)x + d7, (double)y + height, (double)z + d9, texXMin, texHeight);
        d7 = 0.5 + Math.cos((rotation += (double)0.77f) + 2.356194490192345) * scale;
        d9 = 0.5 + Math.sin(rotation + 2.356194490192345) * scale;
        d11 = 0.5 + Math.cos(rotation + 0.7853981633974483) * scale;
        d13 = 0.5 + Math.sin(rotation + 0.7853981633974483) * scale;
        d15 = 0.5 + Math.cos(rotation + 3.9269908169872414) * scale;
        d17 = 0.5 + Math.sin(rotation + 3.9269908169872414) * scale;
        d19 = 0.5 + Math.cos(rotation + 5.497787143782138) * scale;
        d21 = 0.5 + Math.sin(rotation + 5.497787143782138) * scale;
        d28 = -1.0f + upMot * 1.0f;
        texHeight = length * (0.5 / scale) + d28;
        tess.func_78369_a(red, green, blue, 1.0f);
        tess.func_78374_a((double)x + d7, (double)y + height, (double)z + d9, texXMax, texHeight);
        tess.func_78374_a((double)x + d7, (double)y, (double)z + d9, texXMax, d28);
        tess.func_78374_a((double)x + d11, (double)y, (double)z + d13, texXMin, d28);
        tess.func_78374_a((double)x + d11, (double)y + height, (double)z + d13, texXMin, texHeight);
        tess.func_78374_a((double)x + d19, (double)y + height, (double)z + d21, texXMax, texHeight);
        tess.func_78374_a((double)x + d19, (double)y, (double)z + d21, texXMax, d28);
        tess.func_78374_a((double)x + d15, (double)y, (double)z + d17, texXMin, d28);
        tess.func_78374_a((double)x + d15, (double)y + height, (double)z + d17, texXMin, texHeight);
        tess.func_78374_a((double)x + d11, (double)y + height, (double)z + d13, texXMax, texHeight);
        tess.func_78374_a((double)x + d11, (double)y, (double)z + d13, texXMax, d28);
        tess.func_78374_a((double)x + d19, (double)y, (double)z + d21, texXMin, d28);
        tess.func_78374_a((double)x + d19, (double)y + height, (double)z + d21, texXMin, texHeight);
        tess.func_78374_a((double)x + d15, (double)y + height, (double)z + d17, texXMax, texHeight);
        tess.func_78374_a((double)x + d15, (double)y, (double)z + d17, texXMax, d28);
        tess.func_78374_a((double)x + d7, (double)y, (double)z + d9, texXMin, d28);
        tess.func_78374_a((double)x + d7, (double)y + height, (double)z + d9, texXMin, texHeight);
        tess.func_78381_a();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDepthMask((boolean)false);
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.5);
        GL11.glScalef((float)tile.beam_scale, (float)1.0f, (float)tile.beam_scale);
        GL11.glTranslated((double)-0.5, (double)0.0, (double)-0.5);
        tess.func_78382_b();
        tess.func_78370_a(tile.beam_red, tile.beam_green, tile.beam_blue, 32);
        double d30 = 0.2;
        double d4 = 0.2;
        double d6 = 0.8;
        double d8 = 0.2;
        double d10 = 0.2;
        double d12 = 0.8;
        double d14 = 0.8;
        double d16 = 0.8;
        double d18 = length;
        double d20 = 0.0;
        double d22 = 1.0;
        double d24 = -1.0f + upMot;
        double d26 = length + d24;
        tess.func_78374_a((double)x + d30, (double)y + d18, (double)z + d4, d22, d26);
        tess.func_78374_a((double)x + d30, (double)y, (double)z + d4, d22, d24);
        tess.func_78374_a((double)x + d6, (double)y, (double)z + d8, d20, d24);
        tess.func_78374_a((double)x + d6, (double)y + d18, (double)z + d8, d20, d26);
        tess.func_78374_a((double)x + d14, (double)y + d18, (double)z + d16, d22, d26);
        tess.func_78374_a((double)x + d14, (double)y, (double)z + d16, d22, d24);
        tess.func_78374_a((double)x + d10, (double)y, (double)z + d12, d20, d24);
        tess.func_78374_a((double)x + d10, (double)y + d18, (double)z + d12, d20, d26);
        tess.func_78374_a((double)x + d6, (double)y + d18, (double)z + d8, d22, d26);
        tess.func_78374_a((double)x + d6, (double)y, (double)z + d8, d22, d24);
        tess.func_78374_a((double)x + d14, (double)y, (double)z + d16, d20, d24);
        tess.func_78374_a((double)x + d14, (double)y + d18, (double)z + d16, d20, d26);
        tess.func_78374_a((double)x + d10, (double)y + d18, (double)z + d12, d22, d26);
        tess.func_78374_a((double)x + d10, (double)y, (double)z + d12, d22, d24);
        tess.func_78374_a((double)x + d30, (double)y, (double)z + d4, d20, d24);
        tess.func_78374_a((double)x + d30, (double)y + d18, (double)z + d4, d20, d26);
        tess.func_78381_a();
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

