/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools;

import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.MiningTool;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.ToolHandler;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class DraconicDistructionStaff
extends MiningTool
implements IInventoryTool {
    public DraconicDistructionStaff() {
        super(ModItems.DRACONIUM_T3);
        this.func_77655_b("draconicDistructionStaff");
        this.setHarvestLevel("pickaxe", 10);
        this.setHarvestLevel("shovel", 10);
        this.setHarvestLevel("axe", 10);
        this.setCapacity(30000000);
        this.setMaxExtract(150000);
        this.setMaxReceive(150000);
        this.energyPerOperation = 80;
        ModItems.register(this);
    }

    @Override
    public float func_150893_a(ItemStack stack, Block block) {
        return this.efficiencyOnProperMaterial;
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        List<ItemConfigField> list = super.getFields(stack, slot);
        list.add(new ItemConfigField(2, slot, "ToolDigAOE").setMinMaxAndIncromente(0, 4, 1).readFromItem(stack, 0).setModifier("AOE"));
        list.add(new ItemConfigField(2, slot, "ToolDigDepth").setMinMaxAndIncromente(1, 9, 1).readFromItem(stack, 1));
        list.add(new ItemConfigField(2, slot, "WeaponAttackAOE").setMinMaxAndIncromente(0, 12, 1).readFromItem(stack, 1).setModifier("AOE"));
        list.add(new ItemConfigField(6, slot, "ToolVoidJunk").readFromItem(stack, false));
        return list;
    }

    @Override
    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryOblit.txt");
    }

    @Override
    public int getInventorySlots() {
        return 9;
    }

    @Override
    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.digger || enchant.field_77351_y == EnumEnchantmentType.weapon;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        ToolHandler.damageEntityBasedOnHealth(entity, player, 0.3f);
        ToolHandler.AOEAttack(player, entity, stack, ItemNBTHelper.getInteger((ItemStack)stack, (String)"WeaponAttackAOE", (int)0));
        return true;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return super.func_77659_a(stack, world, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extended) {
        super.func_77624_a(stack, player, list, extended);
        list.add("");
        list.add(EnumChatFormatting.BLUE + "+" + ToolHandler.getBaseAttackDamage(stack) + " " + StatCollector.func_74838_a((String)"info.de.attackDamage.txt"));
        list.add(EnumChatFormatting.BLUE + "+30%" + " " + StatCollector.func_74838_a((String)"info.de.bonusHealthDamage.txt"));
    }
}

