/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.handler.MinecraftForgeEventHandler;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;

public class SpeedRequestPacket
implements IMessage {
    double speed = 0.0;

    public SpeedRequestPacket() {
    }

    public SpeedRequestPacket(double speed) {
        this.speed = speed;
    }

    public void toBytes(ByteBuf bytes) {
        bytes.writeDouble(this.speed);
    }

    public void fromBytes(ByteBuf bytes) {
        this.speed = bytes.readDouble();
    }

    public static class Handler
    implements IMessageHandler<SpeedRequestPacket, IMessage> {
        public IMessage onMessage(SpeedRequestPacket message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                if (ConfigHandler.speedLimitDimList.contains(ctx.getServerHandler().field_147369_b.field_71093_bK) || BrandonsCore.proxy.isOp(ctx.getServerHandler().field_147369_b.func_70005_c_()) && !ConfigHandler.speedLimitops) {
                    return new SpeedRequestPacket(20.0);
                }
                LogHelper.info(ConfigHandler.speedLimitops);
                return new SpeedRequestPacket(ConfigHandler.maxPlayerSpeed);
            }
            MinecraftForgeEventHandler.maxSpeed = message.speed;
            MinecraftForgeEventHandler.ticksSinceRequest = 0;
            MinecraftForgeEventHandler.speedNeedsUpdating = false;
            LogHelper.info("Server speed is set to " + message.speed);
            return null;
        }
    }
}

