/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.api;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ReplacementBlock {
    protected byte _hasMeta;
    protected int _meta;
    protected final Block _block;
    protected final NBTTagCompound _tileTag;

    public boolean replaceBlock(World world, int x, int y, int z, ItemStack stack) {
        int meta = this.getMeta(world, x, y, z, stack);
        if (world.func_147465_d(x, y, z, this._block, meta, 3)) {
            TileEntity tile;
            if (this.hasTag(stack) && this._block.hasTileEntity(meta) && (tile = world.func_147438_o(x, y, z)) != null) {
                tile.func_145839_a(this.getTag(world, x, y, z, stack));
            }
            return true;
        }
        return false;
    }

    protected int getMeta(World world, int x, int y, int z, ItemStack stack) {
        int m = 0;
        if (this._hasMeta > 0) {
            if (this._hasMeta > 1) {
                return this._meta;
            }
            m = stack.func_77960_j();
            Item item = stack.func_77973_b();
            if (item instanceof ItemBlock) {
                m = ((ItemBlock)item).func_77647_b(m);
            }
        }
        return m;
    }

    public ReplacementBlock setMeta(int meta) {
        if (meta >= 0) {
            this._hasMeta = (byte)2;
            this._meta = meta;
        }
        return this;
    }

    public ReplacementBlock setMeta(boolean hasMeta) {
        this._hasMeta = (byte)(hasMeta ? 1 : 0);
        return this;
    }

    protected NBTTagCompound getTag(World world, int x, int y, int z, ItemStack stack) {
        return this._tileTag;
    }

    protected boolean hasTag(ItemStack stack) {
        return this._tileTag != null;
    }

    public ReplacementBlock(Item block) {
        this(Block.func_149634_a((Item)block));
    }

    public ReplacementBlock(Item block, NBTTagCompound tag) {
        this(Block.func_149634_a((Item)block), tag);
    }

    public ReplacementBlock(Block block) {
        this(block, null);
    }

    public ReplacementBlock(Block block, NBTTagCompound tag) {
        this._block = block;
        this._tileTag = tag;
    }
}

