/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tablet;

import buildcraft.api.core.BCLog;
import buildcraft.api.tablet.ITablet;
import buildcraft.api.tablet.TabletAPI;
import buildcraft.api.tablet.TabletProgram;
import buildcraft.api.tablet.TabletProgramFactory;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TabletBase
implements ITablet {
    protected final LinkedList<TabletProgram> programs = new LinkedList();

    protected TabletBase() {
    }

    public void tick(float time) {
        if (this.programs.size() > 0) {
            this.programs.getLast().tick(time);
        }
    }

    @Override
    public int getScreenWidth() {
        return 244;
    }

    @Override
    public int getScreenHeight() {
        return 306;
    }

    protected boolean launchProgramInternal(String name) {
        TabletProgramFactory factory = TabletAPI.getProgram(name);
        if (factory == null) {
            BCLog.logger.error("Tried to launch non-existent tablet program on side CLIENT: " + name);
            return false;
        }
        TabletProgram program = factory.create(this);
        if (program == null) {
            BCLog.logger.error("Factory could not create program on side CLIENT: " + name);
            return false;
        }
        this.programs.add(program);
        return true;
    }

    public abstract void receiveMessage(NBTTagCompound var1);

    protected boolean receiveMessageInternal(NBTTagCompound compound) {
        if (compound.func_74764_b("__program")) {
            compound.func_82580_o("__program");
            if (this.programs.getLast() != null) {
                this.programs.getLast().receiveMessage(compound);
            }
            return true;
        }
        if (compound.func_74764_b("programToLaunch")) {
            System.out.println("received");
            this.launchProgramInternal(compound.func_74779_i("programToLaunch"));
            return true;
        }
        return false;
    }
}

